/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.storages.fluid.FluidSink;
import site.siredvin.peripheralium.storages.fluid.FluidStack;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;
import site.siredvin.peripheralium.storages.fluid.FluidStorageExtractor;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralium.xplat.XplatRegistries;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010$\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J4\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0007J4\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\b0\u001eH\u0007J\u0018\u0010#\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\b\u0012\u0002\b\u00030%0$H\u0007R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u000f\u001a\u00020\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006&"}, d2={"Lsite/siredvin/peripheralium/extra/plugins/AbstractFluidStoragePlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "level", "Lnet/minecraft/world/level/Level;", "fluidStorageTransferLimit", "", "(Lnet/minecraft/world/level/Level;I)V", "additionalType", "", "getAdditionalType", "()Ljava/lang/String;", "getFluidStorageTransferLimit", "()I", "getLevel", "()Lnet/minecraft/world/level/Level;", "storage", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "fluidInformation", "", "", "fluid", "Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "pullFluid", "", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "fromName", "limit", "Ljava/util/Optional;", "", "fluidName", "pushFluid", "toName", "tanks", "", "", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nAbstractFluidStoragePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractFluidStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/AbstractFluidStoragePlugin\n+ 2 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n*L\n1#1,80:1\n32#2,2:81\n*S KotlinDebug\n*F\n+ 1 AbstractFluidStoragePlugin.kt\nsite/siredvin/peripheralium/extra/plugins/AbstractFluidStoragePlugin\n*L\n32#1:81,2\n*E\n"})
public abstract class AbstractFluidStoragePlugin
implements IPeripheralPlugin {
    @NotNull
    private final Level level;
    private final int fluidStorageTransferLimit;

    public AbstractFluidStoragePlugin(@NotNull Level level, int fluidStorageTransferLimit) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.level = level;
        this.fluidStorageTransferLimit = fluidStorageTransferLimit;
    }

    @NotNull
    protected final Level getLevel() {
        return this.level;
    }

    protected final int getFluidStorageTransferLimit() {
        return this.fluidStorageTransferLimit;
    }

    @Override
    @NotNull
    public String getAdditionalType() {
        return "fluid_storage";
    }

    @NotNull
    protected Map<String, Object> fluidInformation(@NotNull FluidStack fluid) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        return LuaRepresentation.INSTANCE.forFluidStack(fluid);
    }

    @NotNull
    protected abstract FluidStorage getStorage();

    @LuaFunction(mainThread=true)
    @NotNull
    public final List<Map<String, ?>> tanks() {
        List data = new ArrayList();
        Iterator<FluidStack> $this$forEach$iv = this.getStorage().getFluids();
        boolean $i$f$forEach = false;
        Iterator<FluidStack> iterator = $this$forEach$iv;
        while (iterator.hasNext()) {
            FluidStack element$iv;
            FluidStack it = element$iv = iterator.next();
            boolean bl = false;
            data.add(this.fluidInformation(it));
        }
        return data;
    }

    @LuaFunction(mainThread=true)
    public final double pushFluid(@NotNull IComputerAccess computer, @NotNull String toName, @NotNull Optional<Long> limit, @NotNull Optional<String> fluidName) {
        Predicate<FluidStack> predicate;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(fluidName, (String)"fluidName");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        FluidSink fluidSink = FluidStorageExtractor.INSTANCE.extractFluidSinkFromUnknown(this.level, location.getTarget());
        if (fluidSink == null) {
            throw new LuaException("Target '" + toName + "' is not an fluid inventory");
        }
        FluidSink toStorage = fluidSink;
        if (fluidName.isEmpty()) {
            predicate = AbstractFluidStoragePlugin::pushFluid$lambda$1;
        } else {
            Fluid fluid = XplatRegistries.INSTANCE.getFLUIDS().get(new ResourceLocation(fluidName.get()));
            if (fluid.m_6212_(Fluids.f_76191_)) {
                throw new LuaException("There is no fluid " + fluidName.get());
            }
            predicate = arg_0 -> AbstractFluidStoragePlugin.pushFluid$lambda$2(fluid, arg_0);
        }
        Predicate<FluidStack> predicate2 = predicate;
        long l = this.fluidStorageTransferLimit;
        Long l2 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"limit.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)l2).longValue();
        long realLimit = Math.min(l, l3);
        return this.getStorage().moveTo(toStorage, realLimit, predicate2);
    }

    @LuaFunction(mainThread=true)
    public final double pullFluid(@NotNull IComputerAccess computer, @NotNull String fromName, @NotNull Optional<Long> limit, @NotNull Optional<String> fluidName) {
        Predicate<FluidStack> predicate;
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(fluidName, (String)"fluidName");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        FluidStorage fluidStorage = FluidStorageExtractor.INSTANCE.extractFluidStorageFromUnknown(this.level, location.getTarget());
        if (fluidStorage == null) {
            throw new LuaException("Target '" + fromName + "' is not an fluid inventory");
        }
        FluidStorage fromStorage = fluidStorage;
        if (fluidName.isEmpty()) {
            predicate = AbstractFluidStoragePlugin::pullFluid$lambda$3;
        } else {
            Fluid fluid = XplatRegistries.INSTANCE.getFLUIDS().get(new ResourceLocation(fluidName.get()));
            if (fluid.m_6212_(Fluids.f_76191_)) {
                throw new LuaException("There is no fluid " + fluidName.get());
            }
            predicate = arg_0 -> AbstractFluidStoragePlugin.pullFluid$lambda$4(fluid, arg_0);
        }
        Predicate<FluidStack> predicate2 = predicate;
        long l = this.fluidStorageTransferLimit;
        Long l2 = limit.orElse(Long.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)l2, (String)"limit.orElse(Long.MAX_VALUE)");
        long l3 = ((Number)l2).longValue();
        long realLimit = Math.min(l, l3);
        return this.getStorage().moveFrom(fromStorage, realLimit, predicate2);
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }

    private static final boolean pushFluid$lambda$1(FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pushFluid$lambda$2(Fluid $fluid, FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFluid().m_6212_($fluid);
    }

    private static final boolean pullFluid$lambda$3(FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean pullFluid$lambda$4(Fluid $fluid, FluidStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFluid().m_6212_($fluid);
    }
}

