/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.extra.plugins;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.api.peripheral.IPeripheralOperation;
import site.siredvin.peripheralium.api.peripheral.IPeripheralPlugin;
import site.siredvin.peripheralium.api.peripheral.IPluggablePeripheral;
import site.siredvin.peripheralium.computercraft.peripheral.BoundMethod;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageExtractor;
import site.siredvin.peripheralium.storages.item.ItemStorageUtils;
import site.siredvin.peripheralium.storages.item.SlottedItemSink;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;
import site.siredvin.peripheralium.util.ValidationHelpersKt;
import site.siredvin.peripheralium.util.representation.LuaRepresentation;
import site.siredvin.peripheralium.util.representation.RepresentationMode;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001c\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001e\u0010\u0016\u001a\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00100\u0010H\u0007J\u001e\u0010\u0017\u001a\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u00030\u00100\u0010H\u0016J<\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eH\u0007J<\u0010 \u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120\u001eH\u0007J\b\u0010\"\u001a\u00020\u0012H\u0007J\b\u0010#\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006$"}, d2={"Lsite/siredvin/peripheralium/extra/plugins/AbstractInventoryPlugin;", "Lsite/siredvin/peripheralium/api/peripheral/IPeripheralPlugin;", "()V", "additionalType", "", "getAdditionalType", "()Ljava/lang/String;", "level", "Lnet/minecraft/world/level/Level;", "getLevel", "()Lnet/minecraft/world/level/Level;", "storage", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "getStorage", "()Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "getItemDetail", "", "slot", "", "getItemDetailImpl", "getItemLimit", "getItemLimitImpl", "list", "listImpl", "pullItems", "computer", "Ldan200/computercraft/api/peripheral/IComputerAccess;", "fromName", "fromSlot", "limit", "Ljava/util/Optional;", "toSlot", "pushItems", "toName", "size", "sizeImpl", "peripheralium-forge-1.20.1"})
public abstract class AbstractInventoryPlugin
implements IPeripheralPlugin {
    @NotNull
    public abstract SlottedItemStorage getStorage();

    @NotNull
    public abstract Level getLevel();

    @Override
    @NotNull
    public String getAdditionalType() {
        return "inventory";
    }

    public int sizeImpl() {
        return this.getStorage().getSize();
    }

    @NotNull
    public Map<Integer, Map<String, ?>> listImpl() {
        Map result = new HashMap();
        int size = this.getStorage().getSize();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = this.getStorage().getItem(i);
            if (stack.m_41619_()) continue;
            result.put(i + 1, LuaRepresentation.INSTANCE.forItemStack(stack, RepresentationMode.BASE));
        }
        return result;
    }

    @Nullable
    public Map<String, ?> getItemDetailImpl(int slot) {
        ItemStack stack = this.getStorage().getItem(slot);
        return stack.m_41619_() ? null : LuaRepresentation.forItemStack$default(LuaRepresentation.INSTANCE, stack, null, 2, null);
    }

    public int getItemLimitImpl(int slot) {
        return this.getStorage().getItem(slot).m_41741_();
    }

    @LuaFunction(mainThread=true)
    public final int size() {
        return this.sizeImpl();
    }

    @LuaFunction(mainThread=true)
    @NotNull
    public final Map<Integer, Map<String, ?>> list() {
        return this.listImpl();
    }

    @LuaFunction(mainThread=true)
    @Nullable
    public final Map<String, ?> getItemDetail(int slot) {
        ValidationHelpersKt.assertBetween(slot, 1, this.getStorage().getSize(), "slot");
        return this.getItemDetailImpl(slot - 1);
    }

    @LuaFunction(mainThread=true)
    public final int getItemLimit(int slot) {
        ValidationHelpersKt.assertBetween(slot, 1, this.getStorage().getSize(), "slot");
        return this.getItemLimitImpl(slot - 1);
    }

    @LuaFunction(mainThread=true)
    public final int pushItems(@NotNull IComputerAccess computer, @NotNull String toName, int fromSlot, @NotNull Optional<Integer> limit, @NotNull Optional<Integer> toSlot) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)toName, (String)"toName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(toSlot, (String)"toSlot");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(toName);
        if (iPeripheral == null) {
            throw new LuaException("Target '" + toName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemSink itemSink = ItemStorageExtractor.INSTANCE.extractItemSinkFromUnknown(this.getLevel(), location.getTarget());
        if (itemSink == null) {
            throw new LuaException("Target '" + toName + "' is not an inventory");
        }
        ItemSink toStorage = itemSink;
        Integer n = limit.orElse(Integer.MAX_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"limit.orElse(Int.MAX_VALUE)");
        int actualLimit = ((Number)n).intValue();
        ValidationHelpersKt.assertBetween(fromSlot, 1, this.getStorage().getSize(), "fromtSlot");
        if (toSlot.isPresent()) {
            if (!(toStorage instanceof SlottedItemSink)) {
                throw new LuaException("Target '" + toName + "' is not slotted storage, so you can't provide slot");
            }
            Integer n2 = toSlot.get();
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"toSlot.get()");
            ValidationHelpersKt.assertBetween(((Number)n2).intValue(), 1, ((SlottedItemSink)toStorage).getSize(), "toSlot");
        }
        return actualLimit <= 0 ? 0 : this.getStorage().moveTo(toStorage, actualLimit, fromSlot - 1, ((Number)toSlot.orElse(0)).intValue() - 1, ItemStorageUtils.INSTANCE.getALWAYS());
    }

    @LuaFunction(mainThread=true)
    public final int pullItems(@NotNull IComputerAccess computer, @NotNull String fromName, int fromSlot, @NotNull Optional<Integer> limit, @NotNull Optional<Integer> toSlot) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)computer, (String)"computer");
        Intrinsics.checkNotNullParameter((Object)fromName, (String)"fromName");
        Intrinsics.checkNotNullParameter(limit, (String)"limit");
        Intrinsics.checkNotNullParameter(toSlot, (String)"toSlot");
        IPeripheral iPeripheral = computer.getAvailablePeripheral(fromName);
        if (iPeripheral == null) {
            throw new LuaException("Source '" + fromName + "' does not exist");
        }
        IPeripheral location = iPeripheral;
        ItemSink itemSink = ItemStorageExtractor.INSTANCE.extractItemSinkFromUnknown(this.getLevel(), location.getTarget());
        if (itemSink == null) {
            throw new LuaException("Source '" + fromName + "' is not an inventory");
        }
        ItemSink fromStorage = itemSink;
        if (!(fromStorage instanceof SlottedItemStorage)) {
            throw new LuaException("Source '" + fromName + "' is not slotted storage");
        }
        Integer actualLimit = limit.orElse(Integer.MAX_VALUE);
        ValidationHelpersKt.assertBetween(fromSlot, 1, ((SlottedItemStorage)fromStorage).getSize(), "fromSlot");
        if (toSlot.isPresent()) {
            Integer n = toSlot.get();
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"toSlot.get()");
            ValidationHelpersKt.assertBetween(((Number)n).intValue(), 1, this.getStorage().getSize(), "toSlot");
        }
        Intrinsics.checkNotNullExpressionValue((Object)actualLimit, (String)"actualLimit");
        return actualLimit <= 0 ? 0 : this.getStorage().moveFrom((ItemStorage)fromStorage, actualLimit, ((Number)toSlot.orElse(0)).intValue() - 1, fromSlot - 1, ItemStorageUtils.INSTANCE.getALWAYS());
    }

    @Override
    @Nullable
    public IPluggablePeripheral getConnectedPeripheral() {
        return IPeripheralPlugin.DefaultImpls.getConnectedPeripheral(this);
    }

    @Override
    public void setConnectedPeripheral(@Nullable IPluggablePeripheral value) {
        IPeripheralPlugin.DefaultImpls.setConnectedPeripheral(this, value);
    }

    @Override
    @NotNull
    public List<BoundMethod> getMethods(@NotNull MinecraftServer server) {
        return IPeripheralPlugin.DefaultImpls.getMethods(this, server);
    }

    @Override
    @NotNull
    public List<IPeripheralOperation<?>> getOperations() {
        return IPeripheralPlugin.DefaultImpls.getOperations(this);
    }
}

