/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.storages.item.ItemStorageUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0004J*\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\bJ8\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000bJ.\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralium/storages/ContainerUtils;", "", "()V", "extract", "Lnet/minecraft/world/item/ItemStack;", "container", "Lnet/minecraft/world/Container;", "slot", "", "limit", "predicate", "Ljava/util/function/Predicate;", "previousStack", "storeItem", "stack", "startSlot", "endSlot", "takeItems", "toInventoryOrToWorld", "", "output", "outputPos", "Lnet/minecraft/core/BlockPos;", "level", "Lnet/minecraft/world/level/Level;", "peripheralium-forge-1.20.1"})
public final class ContainerUtils {
    @NotNull
    public static final ContainerUtils INSTANCE = new ContainerUtils();

    private ContainerUtils() {
    }

    @NotNull
    public final ItemStack extract(@NotNull Container container, int slot, int limit, @NotNull ItemStack previousStack) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)previousStack, (String)"previousStack");
        return this.extract(container, slot, limit, arg_0 -> ContainerUtils.extract$lambda$0(previousStack, arg_0));
    }

    @NotNull
    public final ItemStack extract(@NotNull Container container, int slot, int limit, @NotNull Predicate<ItemStack> predicate) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ItemStack existingStack = container.m_8020_(slot);
        if (existingStack.m_41619_() || !predicate.test(existingStack)) {
            ItemStack itemStack = ItemStack.f_41583_;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            return itemStack;
        }
        ItemStack itemStack = container.m_7407_(slot, limit);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"container.removeItem(slot, limit)");
        return itemStack;
    }

    @NotNull
    public final ItemStack takeItems(@NotNull Container container, int limit, int startSlot, int endSlot, @NotNull Predicate<ItemStack> predicate) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Predicate<Object> slidingPredicate = predicate;
        int realEndSlot = endSlot == -1 ? container.m_6643_() - 1 : endSlot;
        int slidingLimit = limit;
        Ref.ObjectRef stack = new Ref.ObjectRef();
        stack.element = ItemStack.f_41583_;
        int currentSlot = startSlot;
        if (currentSlot <= realEndSlot) {
            while (true) {
                if (limit <= 0) {
                    Object object = stack.element;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stack");
                    return (ItemStack)object;
                }
                ItemStack extractedStack = this.extract(container, currentSlot, slidingLimit, predicate);
                if (!extractedStack.m_41619_()) {
                    slidingLimit -= extractedStack.m_41613_();
                    if (((ItemStack)stack.element).m_41619_()) {
                        stack.element = extractedStack;
                        slidingLimit = Math.min(slidingLimit, ((ItemStack)stack.element).m_41741_());
                        Intrinsics.checkNotNullExpressionValue(slidingPredicate.and(arg_0 -> ContainerUtils.takeItems$lambda$1((Function1)new Function1<ItemStack, Boolean>((Ref.ObjectRef<ItemStack>)stack){
                            final /* synthetic */ Ref.ObjectRef<ItemStack> $stack;
                            {
                                this.$stack = $stack;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(ItemStack it) {
                                Object object = this.$stack.element;
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stack");
                                ItemStack itemStack = (ItemStack)object;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                return ItemStorageUtils.INSTANCE.canStack(itemStack, it);
                            }
                        }, arg_0)), (String)"stack = ItemStack.EMPTY\n\u2026ck, it)\n                }");
                    } else {
                        ((ItemStack)stack.element).m_41769_(extractedStack.m_41613_());
                    }
                }
                if (currentSlot == realEndSlot) break;
                ++currentSlot;
            }
        }
        container.m_6596_();
        Object object = stack.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"stack");
        return (ItemStack)object;
    }

    public static /* synthetic */ ItemStack takeItems$default(ContainerUtils containerUtils, Container container, int n, int n2, int n3, Predicate predicate, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n2 = 0;
        }
        if ((n4 & 8) != 0) {
            n3 = -1;
        }
        return containerUtils.takeItems(container, n, n2, n3, predicate);
    }

    @NotNull
    public final ItemStack storeItem(@NotNull Container container, @NotNull ItemStack stack, int startSlot, int endSlot) {
        int realEndSlot;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int maxStackSize = Math.min(stack.m_41741_(), container.m_6893_());
        int n = realEndSlot = endSlot == -1 ? container.m_6643_() - 1 : endSlot;
        if (maxStackSize <= 0) {
            return stack;
        }
        ItemStack slidingStack = stack;
        int currentSlot = startSlot;
        if (currentSlot <= realEndSlot) {
            while (true) {
                ItemStack slotStack;
                if ((slotStack = container.m_8020_(currentSlot)).m_41619_()) {
                    if (container.m_7013_(currentSlot, slidingStack)) {
                        if (slidingStack.m_41613_() <= maxStackSize) {
                            container.m_6836_(currentSlot, slidingStack);
                            ItemStack itemStack = ItemStack.f_41583_;
                            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                            return itemStack;
                        }
                        container.m_6836_(currentSlot, slidingStack.m_41620_(maxStackSize));
                    }
                } else {
                    int slotMaxStackSize = Math.min(slotStack.m_41741_(), maxStackSize);
                    if (slotStack.m_41613_() < slotMaxStackSize) {
                        Intrinsics.checkNotNullExpressionValue((Object)slotStack, (String)"slotStack");
                        if (ItemStorageUtils.INSTANCE.canMerge(slotStack, slidingStack, slotMaxStackSize) && (slidingStack = ItemStorageUtils.inplaceMerge$default(ItemStorageUtils.INSTANCE, slotStack, slidingStack, 0, 4, null)).m_41619_()) {
                            container.m_6596_();
                            ItemStack itemStack = ItemStack.f_41583_;
                            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
                            return itemStack;
                        }
                    }
                }
                if (currentSlot == realEndSlot) break;
                ++currentSlot;
            }
        }
        container.m_6596_();
        return slidingStack;
    }

    public static /* synthetic */ ItemStack storeItem$default(ContainerUtils containerUtils, Container container, ItemStack itemStack, int n, int n2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n = 0;
        }
        if ((n3 & 8) != 0) {
            n2 = -1;
        }
        return containerUtils.storeItem(container, itemStack, n, n2);
    }

    public final void toInventoryOrToWorld(@NotNull ItemStack output, @NotNull Container container, int startSlot, @NotNull BlockPos outputPos, @NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)outputPos, (String)"outputPos");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ItemStack rest = this.storeItem(container, output, startSlot, container.m_6643_() - 1);
        if (!rest.m_41619_() && startSlot > 0) {
            rest = this.storeItem(container, output, 0, startSlot - 1);
        }
        if (!rest.m_41619_()) {
            Containers.m_18992_((Level)level, (double)outputPos.m_123341_(), (double)outputPos.m_123342_(), (double)outputPos.m_123343_(), (ItemStack)rest);
        }
    }

    private static final boolean extract$lambda$0(ItemStack $previousStack, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)$previousStack, (String)"$previousStack");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $previousStack.m_41619_() || ItemStorageUtils.INSTANCE.canStack($previousStack, it);
    }

    private static final boolean takeItems$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

