/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.energy.EnergyHandlerWrapper;
import site.siredvin.peripheralium.storages.energy.EnergyStorage;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;
import site.siredvin.peripheralium.storages.fluid.ForgeFluidStorage;
import site.siredvin.peripheralium.storages.item.ItemHandlerWrapper;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0005\u001a\u0004\u0018\u00010\u0001J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralium/storages/ForgeStorageUtils;", "", "()V", "extractEnergyStorage", "Lnet/minecraftforge/energy/IEnergyStorage;", "something", "extractEnergyStorageFromBlock", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "extractEnergyStorageFromItem", "stack", "Lnet/minecraft/world/item/ItemStack;", "extractFluidHandler", "Lnet/minecraftforge/fluids/capability/IFluidHandler;", "extractFluidStorageFromBlock", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "extractItemHandler", "Lnet/minecraftforge/items/IItemHandler;", "extractStorageFromBlock", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nForgeStorageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForgeStorageUtils.kt\nsite/siredvin/peripheralium/storages/ForgeStorageUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class ForgeStorageUtils {
    @NotNull
    public static final ForgeStorageUtils INSTANCE = new ForgeStorageUtils();

    private ForgeStorageUtils() {
    }

    @Nullable
    public final IEnergyStorage extractEnergyStorage(@Nullable Object something) {
        if (something instanceof BlockEntity && ((BlockEntity)something).m_58901_()) {
            return null;
        }
        if (something instanceof ICapabilityProvider) {
            LazyOptional lazyOptional = ((ICapabilityProvider)something).getCapability(ForgeCapabilities.ENERGY);
            Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"something.getCapability(ForgeCapabilities.ENERGY)");
            LazyOptional cap = lazyOptional;
            if (cap.isPresent()) {
                return (IEnergyStorage)cap.orElseThrow(ForgeStorageUtils::extractEnergyStorage$lambda$0);
            }
        }
        return something instanceof IEnergyStorage ? (IEnergyStorage)something : null;
    }

    @Nullable
    public final IFluidHandler extractFluidHandler(@Nullable Object something) {
        if (something instanceof BlockEntity && ((BlockEntity)something).m_58901_()) {
            return null;
        }
        if (something instanceof ICapabilityProvider) {
            LazyOptional lazyOptional = ((ICapabilityProvider)something).getCapability(ForgeCapabilities.FLUID_HANDLER);
            Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"something.getCapability(\u2026pabilities.FLUID_HANDLER)");
            LazyOptional cap = lazyOptional;
            if (cap.isPresent()) {
                return (IFluidHandler)cap.orElseThrow(ForgeStorageUtils::extractFluidHandler$lambda$1);
            }
        }
        return something instanceof IFluidHandler ? (IFluidHandler)something : null;
    }

    @Nullable
    public final IItemHandler extractItemHandler(@Nullable Object something) {
        IItemHandler iItemHandler;
        if (something instanceof BlockEntity && ((BlockEntity)something).m_58901_()) {
            return null;
        }
        if (something instanceof ICapabilityProvider) {
            LazyOptional lazyOptional = ((ICapabilityProvider)something).getCapability(ForgeCapabilities.ITEM_HANDLER);
            Intrinsics.checkNotNullExpressionValue((Object)lazyOptional, (String)"something.getCapability(\u2026apabilities.ITEM_HANDLER)");
            LazyOptional cap = lazyOptional;
            if (cap.isPresent()) {
                return (IItemHandler)cap.orElseThrow(ForgeStorageUtils::extractItemHandler$lambda$2);
            }
        }
        if ((iItemHandler = something instanceof IItemHandler ? (IItemHandler)something : null) == null) {
            InvWrapper invWrapper;
            Container container = something instanceof Container ? (Container)something : null;
            if (container != null) {
                Container it = container;
                boolean bl = false;
                invWrapper = new InvWrapper(it);
            } else {
                invWrapper = null;
            }
            iItemHandler = (IItemHandler)invWrapper;
        }
        return iItemHandler;
    }

    @Nullable
    public final SlottedItemStorage extractStorageFromBlock(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (blockEntity == null) {
            return null;
        }
        IItemHandler iItemHandler = this.extractItemHandler(blockEntity);
        if (iItemHandler == null) {
            return null;
        }
        IItemHandler itemHandler = iItemHandler;
        return new ItemHandlerWrapper(itemHandler);
    }

    @Nullable
    public final FluidStorage extractFluidStorageFromBlock(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (blockEntity == null) {
            return null;
        }
        IFluidHandler iFluidHandler = this.extractFluidHandler(blockEntity);
        if (iFluidHandler == null) {
            return null;
        }
        IFluidHandler fluidHandler = iFluidHandler;
        return new ForgeFluidStorage(fluidHandler);
    }

    @Nullable
    public final EnergyStorage extractEnergyStorageFromBlock(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (blockEntity == null) {
            return null;
        }
        IEnergyStorage iEnergyStorage = this.extractEnergyStorage(blockEntity);
        if (iEnergyStorage == null) {
            return null;
        }
        IEnergyStorage energyStorage = iEnergyStorage;
        return new EnergyHandlerWrapper(energyStorage);
    }

    @Nullable
    public final EnergyStorage extractEnergyStorageFromItem(@NotNull Level level, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        IEnergyStorage iEnergyStorage = this.extractEnergyStorage(stack);
        if (iEnergyStorage == null) {
            return null;
        }
        IEnergyStorage energyStorage = iEnergyStorage;
        return new EnergyHandlerWrapper(energyStorage);
    }

    private static final NullPointerException extractEnergyStorage$lambda$0() {
        return new NullPointerException();
    }

    private static final NullPointerException extractFluidHandler$lambda$1() {
        return new NullPointerException();
    }

    private static final NullPointerException extractItemHandler$lambda$2() {
        return new NullPointerException();
    }
}

