/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.energy;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.energy.EnergySink;
import site.siredvin.peripheralium.storages.energy.EnergyStack;
import site.siredvin.peripheralium.storages.energy.EnergyStorage;
import site.siredvin.peripheralium.storages.energy.ForgeEnergies;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u001e\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyHandlerWrapper;", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "handler", "Lnet/minecraftforge/energy/IEnergyStorage;", "(Lnet/minecraftforge/energy/IEnergyStorage;)V", "capacity", "", "getCapacity", "()J", "energy", "Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "getEnergy", "()Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "setChanged", "", "storeEnergy", "stack", "takeEnergy", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralium-forge-1.20.1"})
public final class EnergyHandlerWrapper
implements EnergyStorage {
    @NotNull
    private final IEnergyStorage handler;

    public EnergyHandlerWrapper(@NotNull IEnergyStorage handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
    }

    @Override
    @NotNull
    public EnergyStack getEnergy() {
        return new EnergyStack(ForgeEnergies.INSTANCE.getFORGE(), this.handler.getEnergyStored());
    }

    @Override
    public long getCapacity() {
        return this.handler.getMaxEnergyStored();
    }

    @Override
    @NotNull
    public EnergyStack takeEnergy(@NotNull Predicate<EnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return EnergyStack.Companion.getEMPTY();
        }
        int extractedEnergy = this.handler.extractEnergy((int)limit, false);
        return new EnergyStack(ForgeEnergies.INSTANCE.getFORGE(), extractedEnergy);
    }

    @Override
    @NotNull
    public EnergyStack storeEnergy(@NotNull EnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(ForgeEnergies.INSTANCE.getFORGE())) {
            return stack;
        }
        int storedEnergy = this.handler.receiveEnergy((int)stack.getAmount(), false);
        return new EnergyStack(ForgeEnergies.INSTANCE.getFORGE(), storedEnergy);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public long moveTo(@NotNull EnergySink to, long limit, @NotNull Predicate<EnergyStack> takePredicate) {
        return EnergyStorage.DefaultImpls.moveTo(this, to, limit, takePredicate);
    }

    @Override
    public long moveFrom(@NotNull EnergyStorage from, long limit, @NotNull Predicate<EnergyStack> takePredicate) {
        return EnergyStorage.DefaultImpls.moveFrom(this, from, limit, takePredicate);
    }

    @Override
    @Nullable
    public String getMovableType() {
        return EnergyStorage.DefaultImpls.getMovableType(this);
    }
}

