/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.energy;

import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.energy.EnergySink;
import site.siredvin.peripheralium.storages.energy.EnergyStorage;
import site.siredvin.peripheralium.storages.energy.TurtleEnergyStorage;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006%&'()*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u0001J\"\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor;", "", "()V", "ENERGY_SINK_ENTITY_EXTRACTORS", "", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergySinkEntityExtractor;", "ENERGY_SINK_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergySinkExtractor;", "ENERGY_SINK_ITEM_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergySinkItemExtractor;", "ENERGY_STORAGE_ENTITY_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergyStorageEntityExtractor;", "ENERGY_STORAGE_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergyStorageExtractor;", "ENERGY_STORAGE_ITEM_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergyStorageItemExtractor;", "addEnergySinkExtractor", "", "extractor", "addEnergyStorageExtractor", "extractEnergySink", "Lsite/siredvin/peripheralium/storages/energy/EnergySink;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "entity", "Lnet/minecraft/world/entity/Entity;", "stack", "Lnet/minecraft/world/item/ItemStack;", "extractEnergySinkFromUnknown", "obj", "extractEnergyStorage", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "extractEnergyStorageFromUnknown", "EnergySinkEntityExtractor", "EnergySinkExtractor", "EnergySinkItemExtractor", "EnergyStorageEntityExtractor", "EnergyStorageExtractor", "EnergyStorageItemExtractor", "peripheralium-forge-1.20.1"})
public final class EnergyStorageExtractor {
    @NotNull
    public static final EnergyStorageExtractor INSTANCE = new EnergyStorageExtractor();
    @NotNull
    private static final List<EnergySinkExtractor> ENERGY_SINK_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<EnergyStorageExtractor> ENERGY_STORAGE_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<EnergySinkEntityExtractor> ENERGY_SINK_ENTITY_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<EnergyStorageEntityExtractor> ENERGY_STORAGE_ENTITY_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<EnergySinkItemExtractor> ENERGY_SINK_ITEM_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<EnergyStorageItemExtractor> ENERGY_STORAGE_ITEM_EXTRACTORS = new ArrayList();

    private EnergyStorageExtractor() {
    }

    public final void addEnergySinkExtractor(@NotNull EnergySinkExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ENERGY_SINK_EXTRACTORS.add(extractor);
    }

    public final void addEnergyStorageExtractor(@NotNull EnergyStorageExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ENERGY_STORAGE_EXTRACTORS.add(extractor);
    }

    public final void addEnergySinkExtractor(@NotNull EnergySinkEntityExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ENERGY_SINK_ENTITY_EXTRACTORS.add(extractor);
    }

    public final void addEnergyStorageExtractor(@NotNull EnergyStorageEntityExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ENERGY_STORAGE_ENTITY_EXTRACTORS.add(extractor);
    }

    public final void addEnergySinkExtractor(@NotNull EnergySinkItemExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ENERGY_SINK_ITEM_EXTRACTORS.add(extractor);
    }

    public final void addEnergyStorageExtractor(@NotNull EnergyStorageItemExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ENERGY_STORAGE_ITEM_EXTRACTORS.add(extractor);
    }

    @Nullable
    public final EnergyStorage extractEnergyStorage(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        ITurtleAccess turtle;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        for (EnergyStorageExtractor extractor : ENERGY_STORAGE_EXTRACTORS) {
            EnergyStorage result = extractor.extract(level, pos, blockEntity);
            if (result == null) continue;
            return result;
        }
        if (blockEntity != null && (turtle = PeripheraliumPlatform.Companion.getTurtleAccess(blockEntity)) != null) {
            return new TurtleEnergyStorage(turtle);
        }
        return null;
    }

    @Nullable
    public final EnergyStorage extractEnergyStorage(@NotNull Level level, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        for (EnergyStorageEntityExtractor extractor : ENERGY_STORAGE_ENTITY_EXTRACTORS) {
            EnergyStorage result = extractor.extract(level, entity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final EnergyStorage extractEnergyStorage(@NotNull Level level, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        for (EnergyStorageItemExtractor extractor : ENERGY_STORAGE_ITEM_EXTRACTORS) {
            EnergyStorage result = extractor.extract(level, stack);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final EnergyStorage extractEnergyStorageFromUnknown(@NotNull Level level, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (obj == null) {
            return null;
        }
        if (obj instanceof BlockPos) {
            return this.extractEnergyStorage(level, (BlockPos)obj, level.m_7702_((BlockPos)obj));
        }
        if (obj instanceof BlockEntity) {
            BlockPos blockPos = ((BlockEntity)obj).m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"obj.blockPos");
            return this.extractEnergyStorage(level, blockPos, (BlockEntity)obj);
        }
        if (obj instanceof Entity) {
            return this.extractEnergyStorage(level, (Entity)obj);
        }
        if (obj instanceof ItemStack) {
            return this.extractEnergyStorage(level, (ItemStack)obj);
        }
        throw new IllegalArgumentException("Cannot extract storage for " + obj);
    }

    @Nullable
    public final EnergySink extractEnergySink(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        EnergyStorage storage2 = this.extractEnergyStorage(level, pos, blockEntity);
        if (storage2 != null) {
            return storage2;
        }
        for (EnergySinkExtractor extractor : ENERGY_SINK_EXTRACTORS) {
            EnergySink result = extractor.extract(level, pos, blockEntity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final EnergySink extractEnergySink(@NotNull Level level, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        EnergyStorage storage2 = this.extractEnergyStorage(level, entity);
        if (storage2 != null) {
            return storage2;
        }
        for (EnergySinkEntityExtractor extractor : ENERGY_SINK_ENTITY_EXTRACTORS) {
            EnergySink result = extractor.extract(level, entity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final EnergySink extractEnergySink(@NotNull Level level, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        EnergyStorage storage2 = this.extractEnergyStorage(level, stack);
        if (storage2 != null) {
            return storage2;
        }
        for (EnergySinkItemExtractor extractor : ENERGY_SINK_ITEM_EXTRACTORS) {
            EnergyStorage result = extractor.extract(level, stack);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final EnergySink extractEnergySinkFromUnknown(@NotNull Level level, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (obj == null) {
            return null;
        }
        if (obj instanceof BlockPos) {
            return this.extractEnergySink(level, (BlockPos)obj, level.m_7702_((BlockPos)obj));
        }
        if (obj instanceof BlockEntity) {
            BlockPos blockPos = ((BlockEntity)obj).m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"obj.blockPos");
            return this.extractEnergySink(level, blockPos, (BlockEntity)obj);
        }
        if (obj instanceof Entity) {
            return this.extractEnergySink(level, (Entity)obj);
        }
        if (obj instanceof ItemStack) {
            return this.extractEnergySink(level, (ItemStack)obj);
        }
        throw new IllegalArgumentException("Cannot extract storage for " + obj);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergySinkEntityExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/energy/EnergySink;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "peripheralium-forge-1.20.1"})
    public static interface EnergySinkEntityExtractor {
        @Nullable
        public EnergySink extract(@NotNull Level var1, @NotNull Entity var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergySinkExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/energy/EnergySink;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "peripheralium-forge-1.20.1"})
    public static interface EnergySinkExtractor {
        @Nullable
        public EnergySink extract(@NotNull Level var1, @NotNull BlockPos var2, @Nullable BlockEntity var3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergySinkItemExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "level", "Lnet/minecraft/world/level/Level;", "stack", "Lnet/minecraft/world/item/ItemStack;", "peripheralium-forge-1.20.1"})
    public static interface EnergySinkItemExtractor {
        @Nullable
        public EnergyStorage extract(@NotNull Level var1, @NotNull ItemStack var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergyStorageEntityExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "peripheralium-forge-1.20.1"})
    public static interface EnergyStorageEntityExtractor {
        @Nullable
        public EnergyStorage extract(@NotNull Level var1, @NotNull Entity var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergyStorageExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "peripheralium-forge-1.20.1"})
    public static interface EnergyStorageExtractor {
        @Nullable
        public EnergyStorage extract(@NotNull Level var1, @NotNull BlockPos var2, @Nullable BlockEntity var3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStorageExtractor$EnergyStorageItemExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "level", "Lnet/minecraft/world/level/Level;", "stack", "Lnet/minecraft/world/item/ItemStack;", "peripheralium-forge-1.20.1"})
    public static interface EnergyStorageItemExtractor {
        @Nullable
        public EnergyStorage extract(@NotNull Level var1, @NotNull ItemStack var2);
    }
}

