/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.energy;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.siredvin.peripheralium.storages.energy.EnergySink;
import site.siredvin.peripheralium.storages.energy.EnergyStack;
import site.siredvin.peripheralium.storages.energy.EnergyStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\b\u0002\u0010\u0010\u001a\u00020\rJ,\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lsite/siredvin/peripheralium/storages/energy/EnergyStorageUtils;", "", "()V", "ALWAYS", "Ljava/util/function/Predicate;", "Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "getALWAYS", "()Ljava/util/function/Predicate;", "canMerge", "", "first", "second", "stackLimit", "", "canStack", "inplaceMerge", "mergeLimit", "naiveMove", "from", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "to", "Lsite/siredvin/peripheralium/storages/energy/EnergySink;", "limit", "takePredicate", "peripheralium-forge-1.20.1"})
public final class EnergyStorageUtils {
    @NotNull
    public static final EnergyStorageUtils INSTANCE = new EnergyStorageUtils();
    @NotNull
    private static final Predicate<EnergyStack> ALWAYS = EnergyStorageUtils::ALWAYS$lambda$0;

    private EnergyStorageUtils() {
    }

    @NotNull
    public final Predicate<EnergyStack> getALWAYS() {
        return ALWAYS;
    }

    public final long naiveMove(@NotNull EnergyStorage from, @NotNull EnergySink to, long limit, @NotNull Predicate<EnergyStack> takePredicate) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(takePredicate, (String)"takePredicate");
        EnergyStack stack = from.takeEnergy(takePredicate, limit);
        if (stack.isEmpty()) {
            return 0L;
        }
        long stackCount = stack.getAmount();
        EnergyStack remainder = to.storeEnergy(stack);
        long count = stackCount - remainder.getAmount();
        if (!remainder.isEmpty()) {
            from.storeEnergy(remainder);
        }
        return count;
    }

    public final boolean canStack(@NotNull EnergyStack first, @NotNull EnergyStack second) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        return EnergyStack.Companion.isSameEnergy(first, second);
    }

    public final boolean canMerge(@NotNull EnergyStack first, @NotNull EnergyStack second, long stackLimit) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (!this.canStack(first, second)) {
            return false;
        }
        long realStackLimit = stackLimit == -1L ? Long.MAX_VALUE : Math.min(stackLimit, Long.MAX_VALUE);
        return first.getAmount() < realStackLimit;
    }

    public static /* synthetic */ boolean canMerge$default(EnergyStorageUtils energyStorageUtils, EnergyStack energyStack, EnergyStack energyStack2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = -1L;
        }
        return energyStorageUtils.canMerge(energyStack, energyStack2, l);
    }

    @NotNull
    public final EnergyStack inplaceMerge(@NotNull EnergyStack first, @NotNull EnergyStack second, long mergeLimit) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second, (String)"second");
        if (!this.canMerge(first, second, mergeLimit)) {
            return second;
        }
        long mergeSize = Math.min(second.getAmount(), mergeLimit - first.getAmount());
        first.grow(mergeSize);
        second.shrink(mergeSize);
        if (second.isEmpty()) {
            return EnergyStack.Companion.getEMPTY();
        }
        return second;
    }

    public static /* synthetic */ EnergyStack inplaceMerge$default(EnergyStorageUtils energyStorageUtils, EnergyStack energyStack, EnergyStack energyStack2, long l, int n, Object object) {
        if ((n & 4) != 0) {
            l = Long.MAX_VALUE;
        }
        return energyStorageUtils.inplaceMerge(energyStack, energyStack2, l);
    }

    private static final boolean ALWAYS$lambda$0(EnergyStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

