/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.energy;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.energy.Energies;
import site.siredvin.peripheralium.storages.energy.EnergySink;
import site.siredvin.peripheralium.storages.energy.EnergyStack;
import site.siredvin.peripheralium.storages.energy.EnergyStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\nH\u0016J\u001e\u0010\u0011\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lsite/siredvin/peripheralium/storages/energy/TurtleEnergyStorage;", "Lsite/siredvin/peripheralium/storages/energy/EnergyStorage;", "turtle", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;)V", "capacity", "", "getCapacity", "()J", "energy", "Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "getEnergy", "()Lsite/siredvin/peripheralium/storages/energy/EnergyStack;", "setChanged", "", "storeEnergy", "stack", "takeEnergy", "predicate", "Ljava/util/function/Predicate;", "limit", "peripheralium-forge-1.20.1"})
public final class TurtleEnergyStorage
implements EnergyStorage {
    @NotNull
    private final ITurtleAccess turtle;

    public TurtleEnergyStorage(@NotNull ITurtleAccess turtle) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        this.turtle = turtle;
    }

    @Override
    @NotNull
    public EnergyStack getEnergy() {
        return new EnergyStack(Energies.INSTANCE.getTURTLE_FUEL(), this.turtle.getFuelLevel());
    }

    @Override
    public long getCapacity() {
        return this.turtle.getFuelLimit();
    }

    @Override
    @NotNull
    public EnergyStack takeEnergy(@NotNull Predicate<EnergyStack> predicate, long limit) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        if (!predicate.test(this.getEnergy())) {
            return EnergyStack.Companion.getEMPTY();
        }
        long extractedEnergy = Math.min(limit, (long)this.turtle.getFuelLevel());
        this.turtle.addFuel(-((int)extractedEnergy));
        return new EnergyStack(Energies.INSTANCE.getTURTLE_FUEL(), extractedEnergy);
    }

    @Override
    @NotNull
    public EnergyStack storeEnergy(@NotNull EnergyStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!stack.is(Energies.INSTANCE.getTURTLE_FUEL())) {
            return stack;
        }
        long insertedEnergy = Math.min(stack.getAmount(), (long)this.turtle.getFuelLimit() - (long)this.turtle.getFuelLevel());
        this.turtle.addFuel((int)insertedEnergy);
        stack.shrink(insertedEnergy);
        if (stack.getAmount() == 0L) {
            return EnergyStack.Companion.getEMPTY();
        }
        return stack;
    }

    @Override
    public void setChanged() {
        this.turtle.playAnimation(TurtleAnimation.NONE);
    }

    @Override
    public long moveTo(@NotNull EnergySink to, long limit, @NotNull Predicate<EnergyStack> takePredicate) {
        return EnergyStorage.DefaultImpls.moveTo(this, to, limit, takePredicate);
    }

    @Override
    public long moveFrom(@NotNull EnergyStorage from, long limit, @NotNull Predicate<EnergyStack> takePredicate) {
        return EnergyStorage.DefaultImpls.moveFrom(this, from, limit, takePredicate);
    }

    @Override
    @Nullable
    public String getMovableType() {
        return EnergyStorage.DefaultImpls.getMovableType(this);
    }
}

