/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.fluid;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 '2\u00020\u0001:\u0001'B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u0006\u0010\u001b\u001a\u00020\u0000J)\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0005J\u0013\u0010\u001e\u001a\u00020\u00102\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\"J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010#\u001a\u00020\"H\u00d6\u0001J\u000e\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\"J\u000e\u0010$\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u0005J\t\u0010%\u001a\u00020&H\u00d6\u0001R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006("}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "", "fluid", "Lnet/minecraft/world/level/material/Fluid;", "amount", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/world/level/material/Fluid;JLnet/minecraft/nbt/CompoundTag;)V", "getAmount", "()J", "setAmount", "(J)V", "getFluid", "()Lnet/minecraft/world/level/material/Fluid;", "isEmpty", "", "()Z", "platformAmount", "getPlatformAmount", "getTag", "()Lnet/minecraft/nbt/CompoundTag;", "setTag", "(Lnet/minecraft/nbt/CompoundTag;)V", "component1", "component2", "component3", "copy", "copyWithCount", "count", "equals", "other", "grow", "", "", "hashCode", "shrink", "toString", "", "Companion", "peripheralium-forge-1.20.1"})
public final class FluidStack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Fluid fluid;
    private long amount;
    @Nullable
    private CompoundTag tag;
    @NotNull
    private static final FluidStack EMPTY;

    public FluidStack(@NotNull Fluid fluid, long amount, @Nullable CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        this.fluid = fluid;
        this.amount = amount;
        this.tag = tag;
    }

    public /* synthetic */ FluidStack(Fluid fluid, long l, CompoundTag compoundTag, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            compoundTag = null;
        }
        this(fluid, l, compoundTag);
    }

    @NotNull
    public final Fluid getFluid() {
        return this.fluid;
    }

    public final long getAmount() {
        return this.amount;
    }

    public final void setAmount(long l) {
        this.amount = l;
    }

    @Nullable
    public final CompoundTag getTag() {
        return this.tag;
    }

    public final void setTag(@Nullable CompoundTag compoundTag) {
        this.tag = compoundTag;
    }

    public final boolean isEmpty() {
        return this.fluid.m_6212_(Fluids.f_76191_);
    }

    public final long getPlatformAmount() {
        return this.amount * (long)PeripheraliumPlatform.Companion.getFluidCompactDivider();
    }

    @NotNull
    public final FluidStack copy() {
        CompoundTag compoundTag = this.tag;
        return new FluidStack(this.fluid, this.amount, (CompoundTag)(compoundTag != null ? compoundTag.m_6426_() : null));
    }

    @NotNull
    public final FluidStack copyWithCount(long count) {
        CompoundTag compoundTag = this.tag;
        return new FluidStack(this.fluid, count, (CompoundTag)(compoundTag != null ? compoundTag.m_6426_() : null));
    }

    public final void grow(int amount) {
        this.amount += (long)amount;
    }

    public final void shrink(int amount) {
        this.amount -= (long)amount;
    }

    public final void grow(long amount) {
        this.amount += amount;
    }

    public final void shrink(long amount) {
        this.amount -= amount;
    }

    @NotNull
    public final Fluid component1() {
        return this.fluid;
    }

    public final long component2() {
        return this.amount;
    }

    @Nullable
    public final CompoundTag component3() {
        return this.tag;
    }

    @NotNull
    public final FluidStack copy(@NotNull Fluid fluid, long amount, @Nullable CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)fluid, (String)"fluid");
        return new FluidStack(fluid, amount, tag);
    }

    public static /* synthetic */ FluidStack copy$default(FluidStack fluidStack, Fluid fluid, long l, CompoundTag compoundTag, int n, Object object) {
        if ((n & 1) != 0) {
            fluid = fluidStack.fluid;
        }
        if ((n & 2) != 0) {
            l = fluidStack.amount;
        }
        if ((n & 4) != 0) {
            compoundTag = fluidStack.tag;
        }
        return fluidStack.copy(fluid, l, compoundTag);
    }

    @NotNull
    public String toString() {
        return "FluidStack(fluid=" + this.fluid + ", amount=" + this.amount + ", tag=" + this.tag + ")";
    }

    public int hashCode() {
        int result = this.fluid.hashCode();
        result = result * 31 + Long.hashCode(this.amount);
        result = result * 31 + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FluidStack)) {
            return false;
        }
        FluidStack fluidStack = (FluidStack)other;
        if (!Intrinsics.areEqual((Object)this.fluid, (Object)fluidStack.fluid)) {
            return false;
        }
        if (this.amount != fluidStack.amount) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.tag, (Object)fluidStack.tag);
    }

    static {
        Fluid fluid = Fluids.f_76191_;
        Intrinsics.checkNotNullExpressionValue((Object)fluid, (String)"EMPTY");
        EMPTY = new FluidStack(fluid, 0L, null, 4, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStack$Companion;", "", "()V", "EMPTY", "Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "getEMPTY", "()Lsite/siredvin/peripheralium/storages/fluid/FluidStack;", "isSameFluid", "", "first", "second", "isSameFluidSameTags", "peripheralium-forge-1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FluidStack getEMPTY() {
            return EMPTY;
        }

        public final boolean isSameFluid(@NotNull FluidStack first, @NotNull FluidStack second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            return first.getFluid().m_6212_(second.getFluid());
        }

        public final boolean isSameFluidSameTags(@NotNull FluidStack first, @NotNull FluidStack second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            if (!this.isSameFluid(first, second)) {
                return false;
            }
            return Intrinsics.areEqual((Object)first.getTag(), (Object)second.getTag());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

