/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.fluid;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.fluid.FluidSink;
import site.siredvin.peripheralium.storages.fluid.FluidStorage;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0006%&'()*B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u0001J\"\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ\u0018\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u0018\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010!\u001a\u0004\u0018\u00010\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor;", "", "()V", "FLUID_SINK_ENTITY_EXTRACTORS", "", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidSinkEntityExtractor;", "FLUID_SINK_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidSinkExtractor;", "FLUID_SINK_ITEM_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidSinkItemExtractor;", "FLUID_STORAGE_ENTITY_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidStorageEntityExtractor;", "FLUID_STORAGE_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidStorageExtractor;", "FLUID_STORAGE_ITEM_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidStorageItemExtractor;", "addFluidSinkExtractor", "", "extractor", "addFluidStorageExtractor", "extractFluidSink", "Lsite/siredvin/peripheralium/storages/fluid/FluidSink;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "entity", "Lnet/minecraft/world/entity/Entity;", "stack", "Lnet/minecraft/world/item/ItemStack;", "extractFluidSinkFromUnknown", "obj", "extractFluidStorage", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "extractFluidStorageFromUnknown", "FluidSinkEntityExtractor", "FluidSinkExtractor", "FluidSinkItemExtractor", "FluidStorageEntityExtractor", "FluidStorageExtractor", "FluidStorageItemExtractor", "peripheralium-forge-1.20.1"})
public final class FluidStorageExtractor {
    @NotNull
    public static final FluidStorageExtractor INSTANCE = new FluidStorageExtractor();
    @NotNull
    private static final List<FluidSinkExtractor> FLUID_SINK_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<FluidStorageExtractor> FLUID_STORAGE_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<FluidSinkEntityExtractor> FLUID_SINK_ENTITY_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<FluidStorageEntityExtractor> FLUID_STORAGE_ENTITY_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<FluidSinkItemExtractor> FLUID_SINK_ITEM_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<FluidStorageItemExtractor> FLUID_STORAGE_ITEM_EXTRACTORS = new ArrayList();

    private FluidStorageExtractor() {
    }

    public final void addFluidSinkExtractor(@NotNull FluidSinkExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        FLUID_SINK_EXTRACTORS.add(extractor);
    }

    public final void addFluidStorageExtractor(@NotNull FluidStorageExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        FLUID_STORAGE_EXTRACTORS.add(extractor);
    }

    public final void addFluidSinkExtractor(@NotNull FluidSinkEntityExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        FLUID_SINK_ENTITY_EXTRACTORS.add(extractor);
    }

    public final void addFluidStorageExtractor(@NotNull FluidStorageEntityExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        FLUID_STORAGE_ENTITY_EXTRACTORS.add(extractor);
    }

    public final void addFluidSinkExtractor(@NotNull FluidSinkItemExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        FLUID_SINK_ITEM_EXTRACTORS.add(extractor);
    }

    public final void addFluidStorageExtractor(@NotNull FluidStorageItemExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        FLUID_STORAGE_ITEM_EXTRACTORS.add(extractor);
    }

    @Nullable
    public final FluidStorage extractFluidStorage(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        for (FluidStorageExtractor extractor : FLUID_STORAGE_EXTRACTORS) {
            FluidStorage result = extractor.extract(level, pos, blockEntity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final FluidStorage extractFluidStorage(@NotNull Level level, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        for (FluidStorageEntityExtractor extractor : FLUID_STORAGE_ENTITY_EXTRACTORS) {
            FluidStorage result = extractor.extract(level, entity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final FluidStorage extractFluidStorage(@NotNull Level level, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        for (FluidStorageItemExtractor extractor : FLUID_STORAGE_ITEM_EXTRACTORS) {
            FluidStorage result = extractor.extract(level, stack);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final FluidStorage extractFluidStorageFromUnknown(@NotNull Level level, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (obj == null) {
            return null;
        }
        if (obj instanceof BlockPos) {
            return this.extractFluidStorage(level, (BlockPos)obj, level.m_7702_((BlockPos)obj));
        }
        if (obj instanceof BlockEntity) {
            BlockPos blockPos = ((BlockEntity)obj).m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"obj.blockPos");
            return this.extractFluidStorage(level, blockPos, (BlockEntity)obj);
        }
        if (obj instanceof Entity) {
            return this.extractFluidStorage(level, (Entity)obj);
        }
        if (obj instanceof ItemStack) {
            return this.extractFluidStorage(level, (ItemStack)obj);
        }
        throw new IllegalArgumentException("Cannot extract storage for " + obj);
    }

    @Nullable
    public final FluidSink extractFluidSink(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        FluidStorage storage2 = this.extractFluidStorage(level, pos, blockEntity);
        if (storage2 != null) {
            return storage2;
        }
        for (FluidSinkExtractor extractor : FLUID_SINK_EXTRACTORS) {
            FluidSink result = extractor.extract(level, pos, blockEntity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final FluidSink extractFluidSink(@NotNull Level level, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        FluidStorage storage2 = this.extractFluidStorage(level, entity);
        if (storage2 != null) {
            return storage2;
        }
        for (FluidSinkEntityExtractor extractor : FLUID_SINK_ENTITY_EXTRACTORS) {
            FluidSink result = extractor.extract(level, entity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final FluidSink extractFluidSink(@NotNull Level level, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        FluidStorage storage2 = this.extractFluidStorage(level, stack);
        if (storage2 != null) {
            return storage2;
        }
        for (FluidSinkItemExtractor extractor : FLUID_SINK_ITEM_EXTRACTORS) {
            FluidSink result = extractor.extract(level, stack);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final FluidSink extractFluidSinkFromUnknown(@NotNull Level level, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (obj == null) {
            return null;
        }
        if (obj instanceof BlockPos) {
            return this.extractFluidSink(level, (BlockPos)obj, level.m_7702_((BlockPos)obj));
        }
        if (obj instanceof BlockEntity) {
            BlockPos blockPos = ((BlockEntity)obj).m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"obj.blockPos");
            return this.extractFluidSink(level, blockPos, (BlockEntity)obj);
        }
        if (obj instanceof Entity) {
            return this.extractFluidSink(level, (Entity)obj);
        }
        if (obj instanceof ItemStack) {
            return this.extractFluidSink(level, (ItemStack)obj);
        }
        throw new IllegalArgumentException("Cannot extract storage for " + obj);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidSinkEntityExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/fluid/FluidSink;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "peripheralium-forge-1.20.1"})
    public static interface FluidSinkEntityExtractor {
        @Nullable
        public FluidSink extract(@NotNull Level var1, @NotNull Entity var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidSinkExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/fluid/FluidSink;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "peripheralium-forge-1.20.1"})
    public static interface FluidSinkExtractor {
        @Nullable
        public FluidSink extract(@NotNull Level var1, @NotNull BlockPos var2, @Nullable BlockEntity var3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidSinkItemExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/fluid/FluidSink;", "level", "Lnet/minecraft/world/level/Level;", "stack", "Lnet/minecraft/world/item/ItemStack;", "peripheralium-forge-1.20.1"})
    public static interface FluidSinkItemExtractor {
        @Nullable
        public FluidSink extract(@NotNull Level var1, @NotNull ItemStack var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidStorageEntityExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "peripheralium-forge-1.20.1"})
    public static interface FluidStorageEntityExtractor {
        @Nullable
        public FluidStorage extract(@NotNull Level var1, @NotNull Entity var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidStorageExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "peripheralium-forge-1.20.1"})
    public static interface FluidStorageExtractor {
        @Nullable
        public FluidStorage extract(@NotNull Level var1, @NotNull BlockPos var2, @Nullable BlockEntity var3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/fluid/FluidStorageExtractor$FluidStorageItemExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/fluid/FluidStorage;", "level", "Lnet/minecraft/world/level/Level;", "stack", "Lnet/minecraft/world/item/ItemStack;", "peripheralium-forge-1.20.1"})
    public static interface FluidStorageItemExtractor {
        @Nullable
        public FluidStorage extract(@NotNull Level var1, @NotNull ItemStack var2);
    }
}

