/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.storages.item;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.ContainerWrapper;
import site.siredvin.peripheralium.storages.LimitedInventory;
import site.siredvin.peripheralium.storages.item.ItemSink;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.SlottedItemSink;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004!\"#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\tJ\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\"\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0018\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bJ\u001a\u0010 \u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor;", "", "()V", "ADDITIONAL_STORAGE_ENTITY_EXTRACTORS", "", "Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor$StorageEntityExtractor;", "ADDITIONAL_STORAGE_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor$StorageExtractor;", "ADDITIONAL_TARGETABLE_STORAGE_ENTITY_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor$TargetableStorageEntityExtractor;", "ADDITIONAL_TARGETABLE_STORAGE_EXTRACTORS", "Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor$TargetableStorageExtractor;", "addStorageExtractor", "", "extractor", "addTargetableStorageExtractor", "extractContainerFromBlockEntity", "Lnet/minecraft/world/Container;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "extractItemSink", "Lsite/siredvin/peripheralium/storages/item/ItemSink;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "entity", "Lnet/minecraft/world/entity/Entity;", "extractItemSinkFromUnknown", "obj", "extractStorage", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "extractStorageFromUnknown", "StorageEntityExtractor", "StorageExtractor", "TargetableStorageEntityExtractor", "TargetableStorageExtractor", "peripheralium-forge-1.20.1"})
public final class ItemStorageExtractor {
    @NotNull
    public static final ItemStorageExtractor INSTANCE = new ItemStorageExtractor();
    @NotNull
    private static final List<TargetableStorageExtractor> ADDITIONAL_TARGETABLE_STORAGE_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<StorageExtractor> ADDITIONAL_STORAGE_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<TargetableStorageEntityExtractor> ADDITIONAL_TARGETABLE_STORAGE_ENTITY_EXTRACTORS = new ArrayList();
    @NotNull
    private static final List<StorageEntityExtractor> ADDITIONAL_STORAGE_ENTITY_EXTRACTORS = new ArrayList();

    private ItemStorageExtractor() {
    }

    public final void addTargetableStorageExtractor(@NotNull TargetableStorageExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ADDITIONAL_TARGETABLE_STORAGE_EXTRACTORS.add(extractor);
    }

    public final void addStorageExtractor(@NotNull StorageExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ADDITIONAL_STORAGE_EXTRACTORS.add(extractor);
    }

    public final void addTargetableStorageExtractor(@NotNull TargetableStorageEntityExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ADDITIONAL_TARGETABLE_STORAGE_ENTITY_EXTRACTORS.add(extractor);
    }

    public final void addStorageExtractor(@NotNull StorageEntityExtractor extractor) {
        Intrinsics.checkNotNullParameter((Object)extractor, (String)"extractor");
        ADDITIONAL_STORAGE_ENTITY_EXTRACTORS.add(extractor);
    }

    @Nullable
    public final Container extractContainerFromBlockEntity(@NotNull BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        Level level = blockEntity.m_58904_();
        BlockPos pos = blockEntity.m_58899_();
        Level level2 = level;
        Intrinsics.checkNotNull((Object)level2);
        BlockState blockState = level2.m_8055_(pos);
        Block block = blockState.m_60734_();
        return blockEntity instanceof Container ? (blockEntity instanceof ChestBlockEntity && block instanceof ChestBlock ? ChestBlock.m_51511_((ChestBlock)((ChestBlock)block), (BlockState)blockState, (Level)level, (BlockPos)pos, (boolean)true) : (Container)blockEntity) : null;
    }

    @Nullable
    public final ItemStorage extractStorage(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        for (StorageExtractor extractor : ADDITIONAL_STORAGE_EXTRACTORS) {
            ItemStorage result = extractor.extract(level, pos, blockEntity);
            if (result == null) continue;
            return result;
        }
        if (blockEntity != null) {
            if (blockEntity.m_58901_()) {
                return null;
            }
            Container container = this.extractContainerFromBlockEntity(blockEntity);
            if (container != null) {
                return new ContainerWrapper(container);
            }
        }
        if (blockEntity instanceof Container) {
            return new ContainerWrapper((Container)blockEntity);
        }
        return null;
    }

    @Nullable
    public final ItemStorage extractStorage(@NotNull Level level, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity.m_213877_()) {
            return null;
        }
        for (StorageEntityExtractor extractor : ADDITIONAL_STORAGE_ENTITY_EXTRACTORS) {
            ItemStorage result = extractor.extract(level, entity);
            if (result == null) continue;
            return result;
        }
        if (entity instanceof Player) {
            Inventory inventory = ((Player)entity).m_150109_();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"entity.inventory");
            return new ContainerWrapper((Container)inventory);
        }
        if (entity instanceof AbstractChestedHorse && ((AbstractChestedHorse)entity).m_30502_()) {
            SimpleContainer simpleContainer = ((AbstractChestedHorse)entity).f_30520_;
            Intrinsics.checkNotNullExpressionValue((Object)simpleContainer, (String)"entity.inventory");
            int n = 0;
            int n2 = ((AbstractChestedHorse)entity).f_30520_.m_6643_() - 2;
            int[] nArray = new int[n2];
            Container container = (Container)simpleContainer;
            while (n < n2) {
                int n3 = n++;
                nArray[n3] = n3 + 2;
            }
            int[] nArray2 = nArray;
            Container container2 = container;
            Container container3 = new LimitedInventory(container2, nArray2);
            return new ContainerWrapper(container3);
        }
        if (entity instanceof AbstractMinecartContainer) {
            return new ContainerWrapper((Container)entity);
        }
        return null;
    }

    @Nullable
    public final ItemStorage extractStorageFromUnknown(@NotNull Level level, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (obj == null) {
            return null;
        }
        if (obj instanceof BlockPos) {
            return this.extractStorage(level, (BlockPos)obj, level.m_7702_((BlockPos)obj));
        }
        if (obj instanceof BlockEntity) {
            BlockPos blockPos = ((BlockEntity)obj).m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"obj.blockPos");
            return this.extractStorage(level, blockPos, (BlockEntity)obj);
        }
        if (obj instanceof Entity) {
            return this.extractStorage(level, (Entity)obj);
        }
        throw new IllegalArgumentException("Cannot extract storage for " + obj);
    }

    @Nullable
    public final ItemSink extractItemSink(@NotNull Level level, @NotNull BlockPos pos, @Nullable BlockEntity blockEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        ItemStorage storage2 = this.extractStorage(level, pos, blockEntity);
        if (storage2 != null) {
            return storage2;
        }
        for (TargetableStorageExtractor extractor : ADDITIONAL_TARGETABLE_STORAGE_EXTRACTORS) {
            SlottedItemSink result = extractor.extract(level, pos, blockEntity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final ItemSink extractItemSink(@NotNull Level level, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        ItemStorage storage2 = this.extractStorage(level, entity);
        if (storage2 != null) {
            return storage2;
        }
        for (TargetableStorageEntityExtractor extractor : ADDITIONAL_TARGETABLE_STORAGE_ENTITY_EXTRACTORS) {
            SlottedItemSink result = extractor.extract(level, entity);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public final ItemSink extractItemSinkFromUnknown(@NotNull Level level, @Nullable Object obj) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (obj == null) {
            return null;
        }
        if (obj instanceof BlockPos) {
            return this.extractItemSink(level, (BlockPos)obj, level.m_7702_((BlockPos)obj));
        }
        if (obj instanceof BlockEntity) {
            BlockPos blockPos = ((BlockEntity)obj).m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"obj.blockPos");
            return this.extractItemSink(level, blockPos, (BlockEntity)obj);
        }
        if (obj instanceof Entity) {
            return this.extractItemSink(level, (Entity)obj);
        }
        throw new IllegalArgumentException("Cannot extract storage for " + obj);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor$StorageEntityExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "peripheralium-forge-1.20.1"})
    public static interface StorageEntityExtractor {
        @Nullable
        public ItemStorage extract(@NotNull Level var1, @NotNull Entity var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor$StorageExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/item/ItemStorage;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "peripheralium-forge-1.20.1"})
    public static interface StorageExtractor {
        @Nullable
        public ItemStorage extract(@NotNull Level var1, @NotNull BlockPos var2, @Nullable BlockEntity var3);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor$TargetableStorageEntityExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/item/SlottedItemSink;", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "peripheralium-forge-1.20.1"})
    public static interface TargetableStorageEntityExtractor {
        @Nullable
        public SlottedItemSink extract(@NotNull Level var1, @NotNull Entity var2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J$\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH&\u00a8\u0006\n"}, d2={"Lsite/siredvin/peripheralium/storages/item/ItemStorageExtractor$TargetableStorageExtractor;", "", "extract", "Lsite/siredvin/peripheralium/storages/item/SlottedItemSink;", "level", "Lnet/minecraft/world/level/Level;", "pos", "Lnet/minecraft/core/BlockPos;", "blockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "peripheralium-forge-1.20.1"})
    public static interface TargetableStorageExtractor {
        @Nullable
        public SlottedItemSink extract(@NotNull Level var1, @NotNull BlockPos var2, @Nullable BlockEntity var3);
    }
}

