/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util.representation;

import dan200.computercraft.api.lua.LuaException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.ext.BlockPosExtKt;
import site.siredvin.peripheralium.util.representation.LuaInterpretation;
import site.siredvin.peripheralium.xplat.XplatRegistries;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00062\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u000e\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006J\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u000e\u0010\u000e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralium/util/representation/LuaInterpretation;", "", "()V", "asBlockPos", "Lnet/minecraft/core/BlockPos;", "table", "", "center", "facing", "Lnet/minecraft/core/Direction;", "asBlockState", "Lnet/minecraft/world/level/block/state/BlockState;", "asBlockStateAttrs", "state", "blockAttrs", "asID", "Lnet/minecraft/resources/ResourceLocation;", "id", "", "asItemStack", "Lnet/minecraft/world/item/ItemStack;", "obj", "asRotation", "Lnet/minecraft/world/level/block/Rotation;", "rotation", "peripheralium-forge-1.20.1"})
@SourceDebugExtension(value={"SMAP\nLuaInterpretation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuaInterpretation.kt\nsite/siredvin/peripheralium/util/representation/LuaInterpretation\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n215#2:139\n216#2:141\n1#3:140\n*S KotlinDebug\n*F\n+ 1 LuaInterpretation.kt\nsite/siredvin/peripheralium/util/representation/LuaInterpretation\n*L\n81#1:139\n81#1:141\n*E\n"})
public final class LuaInterpretation {
    @NotNull
    public static final LuaInterpretation INSTANCE = new LuaInterpretation();

    private LuaInterpretation() {
    }

    @NotNull
    public final BlockPos asBlockPos(@NotNull Map<?, ?> table) throws LuaException {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        if (!(table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
            throw new LuaException("Table should be block position table");
        }
        Object x = table.get("x");
        Object y = table.get("y");
        Object z = table.get("z");
        if (!(x instanceof Number && y instanceof Number && z instanceof Number)) {
            throw new LuaException("Table should be block position table");
        }
        return new BlockPos(((Number)x).intValue(), ((Number)y).intValue(), ((Number)z).intValue());
    }

    @NotNull
    public final BlockPos asBlockPos(@NotNull BlockPos center, @NotNull Map<?, ?> table) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter(table, (String)"table");
        BlockPos relative = this.asBlockPos(table);
        return new BlockPos(center.m_123341_() + relative.m_123341_(), center.m_123342_() + relative.m_123342_(), center.m_123343_() + relative.m_123343_());
    }

    @NotNull
    public final BlockPos asBlockPos(@NotNull BlockPos center, @NotNull Map<?, ?> table, @NotNull Direction facing) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter(table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        BlockPos relative = BlockPosExtKt.fromRelative(this.asBlockPos(table), facing);
        return new BlockPos(center.m_123341_() + relative.m_123341_(), center.m_123342_() + relative.m_123342_(), center.m_123343_() + relative.m_123343_());
    }

    @NotNull
    public final Rotation asRotation(@NotNull String rotation) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        try {
            String string = rotation.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return Rotation.valueOf((String)string);
        }
        catch (IllegalArgumentException exc) {
            String allValues2 = ArraysKt.joinToString$default((Object[])Rotation.values(), (CharSequence)", ", null, null, (int)0, null, (Function1)asRotation.allValues.1.INSTANCE, (int)30, null);
            throw new LuaException("Rotation should be one of: " + allValues2);
        }
    }

    @NotNull
    public final ResourceLocation asID(@NotNull String id) throws LuaException {
        ResourceLocation resourceLocation;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        try {
            resourceLocation = new ResourceLocation(id);
        }
        catch (ResourceLocationException e) {
            throw new LuaException(e.getMessage());
        }
        return resourceLocation;
    }

    @NotNull
    public final ItemStack asItemStack(@Nullable Object obj) throws LuaException {
        if (obj instanceof String) {
            ItemStack candidate = XplatRegistries.INSTANCE.getITEMS().get(this.asID((String)obj)).m_7968_();
            if (candidate.m_41619_()) {
                throw new LuaException("Cannot find item with id " + obj);
            }
            Intrinsics.checkNotNullExpressionValue((Object)candidate, (String)"candidate");
            return candidate;
        }
        if (obj instanceof Map) {
            Object v = ((Map)obj).get("item");
            String string = v instanceof String ? (String)v : null;
            if (string == null) {
                throw new LuaException("Item stack table should contains item field with item id");
            }
            String id = string;
            Integer n = ((Map)obj).getOrDefault("count", 1);
            Number number = n instanceof Number ? (Number)n : (Number)null;
            if (number == null) {
                throw new LuaException("Count field should be a number");
            }
            Number count = number;
            ItemStack candidate = XplatRegistries.INSTANCE.getITEMS().get(this.asID(id)).m_7968_();
            if (candidate.m_41619_()) {
                throw new LuaException("Cannot find item with id " + obj);
            }
            ItemStack itemStack = candidate.m_255036_(count.intValue());
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"candidate.copyWithCount(count.toInt())");
            return itemStack;
        }
        throw new LuaException("Item stack should be item id or table with item id and count");
    }

    @NotNull
    public final BlockState asBlockStateAttrs(@NotNull BlockState state, @NotNull Map<?, ?> blockAttrs) throws LuaException {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(blockAttrs, (String)"blockAttrs");
        Object changeableState = null;
        changeableState = state;
        Map<?, ?> $this$forEach$iv = blockAttrs;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<?, ?>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Property property;
            Object v1;
            Object object;
            Object[] objectArray;
            Object object2;
            Map.Entry<?, ?> attr;
            block9: {
                Map.Entry<?, ?> element$iv;
                attr = element$iv = iterator.next();
                boolean bl = false;
                Collection collection = state.m_61147_();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"state.properties");
                object2 = collection;
                objectArray = object2.iterator();
                while (objectArray.hasNext()) {
                    object = objectArray.next();
                    Property it = (Property)object;
                    boolean bl2 = false;
                    if (!it.m_61708_().equals(attr.getKey())) continue;
                    v1 = object;
                    break block9;
                }
                v1 = null;
            }
            if ((Property)v1 == null) {
                object2 = "Unknown property name %s";
                objectArray = new Object[]{attr.getKey()};
                String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                throw new LuaException(string);
            }
            Property property2 = property;
            if (property2 instanceof EnumProperty) {
                Comparable targetValue;
                Object v5;
                block10: {
                    Intrinsics.checkNotNullExpressionValue((Object)String.valueOf(attr.getValue()).toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Collection collection = property.m_6908_();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"property.getPossibleValues()");
                    Iterable iterable = collection;
                    for (Object t : iterable) {
                        String value;
                        Comparable it = (Comparable)t;
                        boolean bl = false;
                        String string = it.toString().toLowerCase(Locale.ROOT);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                        if (!Intrinsics.areEqual((Object)string, (Object)value)) continue;
                        v5 = t;
                        break block10;
                    }
                    v5 = null;
                }
                if ((Comparable)v5 == null) {
                    object = new Object[2];
                    object[0] = attr.getKey();
                    Collection collection = property.m_6908_();
                    Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"property.getPossibleValues()");
                    object[1] = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
                    throw new LuaException(String.format("Incorrect value %s, only %s is allowed", object));
                }
                Intrinsics.checkNotNull((Object)property, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.properties.Property<kotlin.Comparable<kotlin.Any>>");
                Property trickedProperty = property;
                Intrinsics.checkNotNull((Object)targetValue, (String)"null cannot be cast to non-null type kotlin.Comparable<kotlin.Any>");
                Intrinsics.checkNotNullExpressionValue((Object)changeableState.m_61124_(trickedProperty, targetValue), (String)"changeableState.setValue\u2026Value as Comparable<Any>)");
                continue;
            }
            if (property2 instanceof BooleanProperty) {
                if (!(attr.getValue() instanceof Boolean)) {
                    object2 = "Incorrect value %s, should be boolean";
                    objectArray = new Object[]{attr.getKey()};
                    String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                    throw new LuaException(string);
                }
                Object obj = attr.getValue();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Boolean");
                Intrinsics.checkNotNullExpressionValue((Object)changeableState.m_61124_(property, (Comparable)((Boolean)obj)), (String)"changeableState.setValue\u2026y, attr.value as Boolean)");
                continue;
            }
            if (!(property2 instanceof IntegerProperty)) continue;
            if (!(attr.getValue() instanceof Number)) {
                object2 = "Incorrect value %s, should be boolean";
                objectArray = new Object[]{attr.getKey()};
                String string = String.format((String)object2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
                throw new LuaException(string);
            }
            Object obj = attr.getValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Number");
            Intrinsics.checkNotNullExpressionValue((Object)changeableState.m_61124_(property, (Comparable)Integer.valueOf(((Number)obj).intValue())), (String)"changeableState.setValue\u2026value as Number).toInt())");
        }
        return changeableState;
    }

    @NotNull
    public final BlockState asBlockState(@NotNull Map<?, ?> table) throws LuaException {
        Intrinsics.checkNotNullParameter(table, (String)"table");
        if (table.containsKey("block")) {
            String blockID = String.valueOf(table.get("block"));
            Block block = XplatRegistries.INSTANCE.getBLOCKS().get(new ResourceLocation(blockID));
            if (Intrinsics.areEqual((Object)block, (Object)Blocks.f_50016_)) {
                String string = "Cannot find block %s";
                Object[] objectArray = new Object[]{table.get("block")};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                throw new LuaException(string2);
            }
            BlockState targetState = block.m_49966_();
            if (table.containsKey("attrs")) {
                Object obj = table.get("attrs");
                Map map = obj instanceof Map ? (Map)obj : null;
                if (map == null) {
                    throw new LuaException("attrs should be a table");
                }
                Map blockAttrs = map;
                BlockState blockState = targetState;
                Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"targetState");
                targetState = this.asBlockStateAttrs(blockState, blockAttrs);
            }
            BlockState blockState = targetState;
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"targetState");
            return blockState;
        }
        throw new LuaException("Table should contains at least block field");
    }
}

