/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util.world;

import com.mojang.authlib.GameProfile;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.item.ItemStorage;
import site.siredvin.peripheralium.storages.item.ItemStorageExtractor;
import site.siredvin.peripheralium.storages.item.ItemStorageUtils;
import site.siredvin.peripheralium.storages.item.SlottedItemStorage;
import site.siredvin.peripheralium.util.world.FakePlayerProxy;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J8\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002JK\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u000e2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00190\u001b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u001cR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lsite/siredvin/peripheralium/util/world/FakePlayerProviderEntity;", "", "()V", "registeredPlayers", "Ljava/util/WeakHashMap;", "Lnet/minecraft/world/entity/Entity;", "Lsite/siredvin/peripheralium/util/world/FakePlayerProxy;", "getPlayer", "entity", "profile", "Lcom/mojang/authlib/GameProfile;", "load", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "realPlayer", "Lnet/minecraft/world/entity/player/Player;", "storage", "Lsite/siredvin/peripheralium/storages/item/SlottedItemStorage;", "overwrittenDirection", "Lnet/minecraft/core/Direction;", "skipInventory", "", "unload", "withPlayer", "T", "function", "Ljava/util/function/Function;", "(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/server/level/ServerPlayer;Ljava/util/function/Function;Lnet/minecraft/core/Direction;Z)Ljava/lang/Object;", "peripheralium-forge-1.20.1"})
public final class FakePlayerProviderEntity {
    @NotNull
    public static final FakePlayerProviderEntity INSTANCE = new FakePlayerProviderEntity();
    @NotNull
    private static final WeakHashMap<Entity, FakePlayerProxy> registeredPlayers = new WeakHashMap();

    private FakePlayerProviderEntity() {
    }

    private final FakePlayerProxy getPlayer(Entity entity, GameProfile profile) {
        FakePlayerProxy fake = registeredPlayers.get(entity);
        if (fake == null) {
            Level level = entity.m_9236_();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            fake = new FakePlayerProxy(PeripheraliumPlatform.Companion.createFakePlayer((ServerLevel)level, profile), 0, 2, null);
            ((Map)registeredPlayers).put(entity, fake);
        }
        return fake;
    }

    private final void load(ServerPlayer player, Player realPlayer, SlottedItemStorage storage2, Direction overwrittenDirection, boolean skipInventory) {
        float pitch;
        Direction direction = overwrittenDirection;
        if (direction == null) {
            direction = realPlayer.m_6350_();
        }
        Direction direction2 = direction;
        Level level = realPlayer.m_9236_();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        player.m_284127_((ServerLevel)level);
        BlockPos position = realPlayer.m_20183_();
        float f = direction2 == Direction.UP ? -90.0f : (pitch = direction2 == Direction.DOWN ? 90.0f : 0.0f);
        float yaw = direction2 == Direction.SOUTH ? 0.0f : (direction2 == Direction.WEST ? 90.0f : (direction2 == Direction.NORTH ? 180.0f : -90.0f));
        Vec3i sideVec = direction2.m_122436_();
        Direction.Axis a = direction2.m_122434_();
        Direction.AxisDirection ad = direction2.m_122421_();
        double x = a == Direction.Axis.X && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.m_123341_() / 1.9;
        double y = 0.5 + (double)sideVec.m_123342_() / 1.9;
        double z = a == Direction.Axis.Z && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.m_123343_() / 1.9;
        player.m_7678_((double)position.m_123341_() + x, (double)position.m_123342_() + y, (double)position.m_123343_() + z, yaw, pitch);
        if (!skipInventory && storage2 != null) {
            int i;
            Inventory inventory = player.m_150109_();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"player.inventory");
            Inventory playerInventory = inventory;
            playerInventory.f_35977_ = 0;
            int size = storage2.getSize();
            int fakeInventorySize = playerInventory.m_6643_();
            for (i = 0; i < size; ++i) {
                playerInventory.m_6836_(i, storage2.getItem(i));
            }
            if (fakeInventorySize > size) {
                for (i = size; i < fakeInventorySize; ++i) {
                    playerInventory.m_6836_(i, ItemStack.f_41583_);
                }
            }
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.getItemInHand(InteractionHand.MAIN_HAND)");
            ItemStack activeStack = itemStack;
            if (!activeStack.m_41619_()) {
                player.m_21204_().m_22178_(activeStack.m_41638_(EquipmentSlot.MAINHAND));
            }
        }
    }

    static /* synthetic */ void load$default(FakePlayerProviderEntity fakePlayerProviderEntity, ServerPlayer serverPlayer, Player player, SlottedItemStorage slottedItemStorage, Direction direction, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            direction = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        fakePlayerProviderEntity.load(serverPlayer, player, slottedItemStorage, direction, bl);
    }

    private final void unload(ServerPlayer player, Player realPlayer, SlottedItemStorage storage2, boolean skipInventory) {
        Inventory inventory = player.m_150109_();
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"player.inventory");
        Inventory playerInventory = inventory;
        playerInventory.f_35977_ = 0;
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.getItemInHand(InteractionHand.MAIN_HAND)");
        ItemStack activeStack = itemStack;
        if (!activeStack.m_41619_()) {
            player.m_21204_().m_22161_(activeStack.m_41638_(EquipmentSlot.MAINHAND));
        }
        if (!skipInventory && storage2 != null) {
            int i;
            int size = storage2.getSize();
            int fakeInventorySize = playerInventory.m_6643_();
            playerInventory.f_35977_ = realPlayer.m_36344_();
            for (i = 0; i < size; ++i) {
                ItemStack itemStack2 = playerInventory.m_8020_(i);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"playerInventory.getItem(i)");
                storage2.storeItem(itemStack2, i, i);
                playerInventory.m_6836_(i, ItemStack.f_41583_);
            }
            if (fakeInventorySize > size) {
                for (i = size; i < fakeInventorySize; ++i) {
                    ItemStack remaining = playerInventory.m_8020_(i);
                    if (!remaining.m_41619_()) {
                        Intrinsics.checkNotNullExpressionValue((Object)remaining, (String)"remaining");
                        BlockPos blockPos = realPlayer.m_20183_();
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"realPlayer.blockPosition()");
                        Level level = realPlayer.m_9236_();
                        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"realPlayer.level()");
                        ItemStorageUtils.INSTANCE.toInventoryOrToWorld(remaining, storage2, 0, blockPos, level);
                    }
                    playerInventory.m_6836_(i, ItemStack.f_41583_);
                }
            }
        }
    }

    static /* synthetic */ void unload$default(FakePlayerProviderEntity fakePlayerProviderEntity, ServerPlayer serverPlayer, Player player, SlottedItemStorage slottedItemStorage, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        fakePlayerProviderEntity.unload(serverPlayer, player, slottedItemStorage, bl);
    }

    public final <T> T withPlayer(@NotNull Entity entity, @NotNull ServerPlayer realPlayer, @NotNull Function<FakePlayerProxy, T> function, @Nullable Direction overwrittenDirection, boolean skipInventory) {
        SlottedItemStorage storage2;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)realPlayer, (String)"realPlayer");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        GameProfile gameProfile = realPlayer.m_36316_();
        Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"realPlayer.gameProfile");
        FakePlayerProxy player = this.getPlayer(entity, gameProfile);
        Level level = entity.m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"entity.level()");
        ItemStorage itemStorage = ItemStorageExtractor.INSTANCE.extractStorage(level, entity);
        SlottedItemStorage slottedItemStorage = storage2 = itemStorage instanceof SlottedItemStorage ? (SlottedItemStorage)itemStorage : null;
        if (!skipInventory && storage2 == null) {
            throw new IllegalArgumentException("Cannot init fake player with storage and with block entity without storage");
        }
        this.load(player.getFakePlayer(), (Player)realPlayer, storage2, overwrittenDirection, skipInventory);
        T result = function.apply(player);
        this.unload(player.getFakePlayer(), (Player)realPlayer, storage2, skipInventory);
        return result;
    }

    public static /* synthetic */ Object withPlayer$default(FakePlayerProviderEntity fakePlayerProviderEntity, Entity entity, ServerPlayer serverPlayer, Function function, Direction direction, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            direction = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return fakePlayerProviderEntity.withPlayer(entity, serverPlayer, function, direction, bl);
    }
}

