/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.peripheralium.util.world;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.peripheralium.storages.ContainerUtils;
import site.siredvin.peripheralium.util.world.FakePlayerProxy;
import site.siredvin.peripheralium.xplat.PeripheraliumPlatform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002JC\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\b\u001a\u00020\u00052\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00150\u00172\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0018R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lsite/siredvin/peripheralium/util/world/FakePlayerProviderTurtle;", "", "()V", "registeredPlayers", "Ljava/util/WeakHashMap;", "Ldan200/computercraft/api/turtle/ITurtleAccess;", "Lsite/siredvin/peripheralium/util/world/FakePlayerProxy;", "getPlayer", "turtle", "profile", "Lcom/mojang/authlib/GameProfile;", "load", "", "player", "Lnet/minecraft/server/level/ServerPlayer;", "overwrittenDirection", "Lnet/minecraft/core/Direction;", "skipInventory", "", "unload", "withPlayer", "T", "function", "Ljava/util/function/Function;", "(Ldan200/computercraft/api/turtle/ITurtleAccess;Ljava/util/function/Function;Lnet/minecraft/core/Direction;Z)Ljava/lang/Object;", "peripheralium-forge-1.20.1"})
public final class FakePlayerProviderTurtle {
    @NotNull
    public static final FakePlayerProviderTurtle INSTANCE = new FakePlayerProviderTurtle();
    @NotNull
    private static final WeakHashMap<ITurtleAccess, FakePlayerProxy> registeredPlayers = new WeakHashMap();

    private FakePlayerProviderTurtle() {
    }

    private final FakePlayerProxy getPlayer(ITurtleAccess turtle, GameProfile profile) {
        FakePlayerProxy fake = registeredPlayers.get(turtle);
        if (fake == null) {
            Level level = turtle.getLevel();
            Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            fake = new FakePlayerProxy(PeripheraliumPlatform.Companion.createFakePlayer((ServerLevel)level, profile), 0, 2, null);
            ((Map)registeredPlayers).put(turtle, fake);
        }
        return fake;
    }

    private final void load(ServerPlayer player, ITurtleAccess turtle, Direction overwrittenDirection, boolean skipInventory) {
        float pitch;
        Direction direction = overwrittenDirection;
        if (direction == null) {
            direction = turtle.getDirection();
        }
        Direction direction2 = direction;
        Level level = turtle.getLevel();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        player.m_284127_((ServerLevel)level);
        BlockPos position = turtle.getPosition();
        float f = direction2 == Direction.UP ? -90.0f : (pitch = direction2 == Direction.DOWN ? 90.0f : 0.0f);
        float yaw = direction2 == Direction.SOUTH ? 0.0f : (direction2 == Direction.WEST ? 90.0f : (direction2 == Direction.NORTH ? 180.0f : -90.0f));
        Vec3i sideVec = direction2.m_122436_();
        Direction.Axis a = direction2.m_122434_();
        Direction.AxisDirection ad = direction2.m_122421_();
        double x = a == Direction.Axis.X && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.m_123341_() / 1.9;
        double y = 0.5 + (double)sideVec.m_123342_() / 1.9;
        double z = a == Direction.Axis.Z && ad == Direction.AxisDirection.NEGATIVE ? -0.5 : 0.5 + (double)sideVec.m_123343_() / 1.9;
        player.m_7678_((double)position.m_123341_() + x, (double)position.m_123342_() + y, (double)position.m_123343_() + z, yaw, pitch);
        if (!skipInventory) {
            int i;
            Inventory inventory = player.m_150109_();
            Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"player.inventory");
            Inventory playerInventory = inventory;
            playerInventory.f_35977_ = 0;
            Container turtleInventory = turtle.getInventory();
            int size = turtleInventory.m_6643_();
            int largerSize = playerInventory.m_6643_();
            playerInventory.f_35977_ = turtle.getSelectedSlot();
            for (i = 0; i < size; ++i) {
                playerInventory.m_6836_(i, turtleInventory.m_8020_(i));
            }
            for (i = size; i < largerSize; ++i) {
                playerInventory.m_6836_(i, ItemStack.f_41583_);
            }
            ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.getItemInHand(InteractionHand.MAIN_HAND)");
            ItemStack activeStack = itemStack;
            if (!activeStack.m_41619_()) {
                player.m_21204_().m_22178_(activeStack.m_41638_(EquipmentSlot.MAINHAND));
            }
        }
    }

    static /* synthetic */ void load$default(FakePlayerProviderTurtle fakePlayerProviderTurtle, ServerPlayer serverPlayer, ITurtleAccess iTurtleAccess, Direction direction, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            direction = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        fakePlayerProviderTurtle.load(serverPlayer, iTurtleAccess, direction, bl);
    }

    private final void unload(ServerPlayer player, ITurtleAccess turtle, boolean skipInventory) {
        Inventory inventory = player.m_150109_();
        Intrinsics.checkNotNullExpressionValue((Object)inventory, (String)"player.inventory");
        Inventory playerInventory = inventory;
        playerInventory.f_35977_ = 0;
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"player.getItemInHand(InteractionHand.MAIN_HAND)");
        ItemStack activeStack = itemStack;
        if (!activeStack.m_41619_()) {
            player.m_21204_().m_22161_(activeStack.m_41638_(EquipmentSlot.MAINHAND));
        }
        if (!skipInventory) {
            int i;
            Container turtleInventory = turtle.getInventory();
            int size = turtleInventory.m_6643_();
            int largerSize = playerInventory.m_6643_();
            playerInventory.f_35977_ = turtle.getSelectedSlot();
            for (i = 0; i < size; ++i) {
                turtleInventory.m_6836_(i, playerInventory.m_8020_(i));
                playerInventory.m_6836_(i, ItemStack.f_41583_);
            }
            for (i = size; i < largerSize; ++i) {
                ItemStack remaining = playerInventory.m_8020_(i);
                if (!remaining.m_41619_()) {
                    Intrinsics.checkNotNullExpressionValue((Object)remaining, (String)"remaining");
                    Intrinsics.checkNotNullExpressionValue((Object)turtleInventory, (String)"turtleInventory");
                    BlockPos blockPos = turtle.getPosition();
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"turtle.position");
                    Level level = turtle.getLevel();
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"turtle.level");
                    ContainerUtils.INSTANCE.toInventoryOrToWorld(remaining, turtleInventory, 0, blockPos, level);
                }
                playerInventory.m_6836_(i, ItemStack.f_41583_);
            }
        }
    }

    static /* synthetic */ void unload$default(FakePlayerProviderTurtle fakePlayerProviderTurtle, ServerPlayer serverPlayer, ITurtleAccess iTurtleAccess, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        fakePlayerProviderTurtle.unload(serverPlayer, iTurtleAccess, bl);
    }

    public final <T> T withPlayer(@NotNull ITurtleAccess turtle, @NotNull Function<FakePlayerProxy, T> function, @Nullable Direction overwrittenDirection, boolean skipInventory) {
        Intrinsics.checkNotNullParameter((Object)turtle, (String)"turtle");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        GameProfile gameProfile = turtle.getOwningPlayer();
        if (gameProfile == null) {
            gameProfile = FakePlayerProxy.Companion.getDUMMY_PROFILE();
        }
        Intrinsics.checkNotNullExpressionValue((Object)gameProfile, (String)"turtle.owningPlayer ?: F\u2026PlayerProxy.DUMMY_PROFILE");
        FakePlayerProxy player = this.getPlayer(turtle, gameProfile);
        this.load(player.getFakePlayer(), turtle, overwrittenDirection, skipInventory);
        T result = function.apply(player);
        this.unload(player.getFakePlayer(), turtle, skipInventory);
        return result;
    }

    public static /* synthetic */ Object withPlayer$default(FakePlayerProviderTurtle fakePlayerProviderTurtle, ITurtleAccess iTurtleAccess, Function function, Direction direction, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            direction = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return fakePlayerProviderTurtle.withPlayer(iTurtleAccess, function, direction, bl);
    }
}

