/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.satisfy.lilis_lucky_lures.client.model.entity.FloatingDebrisModel;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class FloatingDebrisRenderer
extends EntityRenderer<FloatingDebrisEntity> {
    private static final ResourceLocation TEXTURE = new LilisLuckyLuresIdentifier("textures/entity/floating_debris.png");
    private final FloatingDebrisModel<FloatingDebrisEntity> model;

    public FloatingDebrisRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new FloatingDebrisModel(context.m_174023_(FloatingDebrisModel.LAYER_LOCATION));
    }

    @NotNull
    public ResourceLocation getTextureLocation(FloatingDebrisEntity entity) {
        return TEXTURE;
    }

    public void render(FloatingDebrisEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        Quaternionf rotation = new Quaternionf().rotateY((float)Math.toRadians(entity.getRandomRotation()));
        poseStack.m_85850_().m_252922_().rotate((Quaternionfc)rotation);
        float ageInTicks = (float)entity.f_19797_ + partialTicks;
        this.model.m_6973_(entity, 0.0f, 0.0f, ageInTicks, entityYaw, 0.0f);
        int overlay = entity.getHurtTime() > 0 ? 3 : OverlayTexture.f_118083_;
        this.model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE)), packedLight, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

