/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.satisfy.lilis_lucky_lures.client.model.entity.OceanFishPoolModel;
import net.satisfy.lilis_lucky_lures.core.entity.OceanFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class OceanFishPoolRenderer
extends EntityRenderer<OceanFishPoolEntity> {
    private static final ResourceLocation TEXTURE = new LilisLuckyLuresIdentifier("textures/entity/ocean_fish_pool.png");
    private final OceanFishPoolModel<OceanFishPoolEntity> model;

    public OceanFishPoolRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new OceanFishPoolModel(context.m_174023_(OceanFishPoolModel.LAYER_LOCATION));
    }

    @NotNull
    public ResourceLocation getTextureLocation(OceanFishPoolEntity entity) {
        return TEXTURE;
    }

    public void render(OceanFishPoolEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(new Quaternionf().rotateX((float)Math.PI));
        Quaternionf rotationRandom = new Quaternionf().rotateY((float)Math.toRadians(entity.getRandomRotation()));
        poseStack.m_252781_(rotationRandom);
        poseStack.m_85837_(0.0, -3.5, 0.0);
        float ageInTicks = (float)entity.f_19797_ + partialTicks;
        this.model.setupAnim(entity, 0.0f, 0.0f, ageInTicks, entityYaw, 0.0f);
        int overlay = entity.getHurtTime() > 0 ? 3 : OverlayTexture.f_118083_;
        this.model.m_7695_(poseStack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)TEXTURE)), packedLight, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }
}

