/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.lilis_lucky_lures.core.block.entity.HangingFrameBlockEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HangingFrameBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.m_61587_((String)"half", DoubleBlockHalf.class);
    private static final VoxelShape TOP_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)Shapes.m_83040_(), (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.4375, (double)1.0, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.4375, (double)0.125, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.875, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.625, (double)0.4375, (double)0.875, (double)0.875, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape BOTTOM_SHAPE = Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)Shapes.m_83113_((VoxelShape)Shapes.m_83040_(), (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.125, (double)0.4375, (double)0.125, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.125, (double)0.4375, (double)1.0, (double)0.625, (double)0.5625), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.0, (double)0.3125, (double)0.125, (double)0.125, (double)0.6875), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)Shapes.m_83048_((double)0.875, (double)0.0, (double)0.3125, (double)1.0, (double)0.125, (double)0.6875), (BooleanOp)BooleanOp.f_82695_), (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.625, (double)0.4375, (double)1.0, (double)1.0, (double)0.5625), (BooleanOp)BooleanOp.f_82695_);
    private static final Map<Direction, VoxelShape> TOP_SHAPES = new HashMap<Direction, VoxelShape>();
    private static final Map<Direction, VoxelShape> BOTTOM_SHAPES = new HashMap<Direction, VoxelShape>();

    public HangingFrameBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, HALF});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos posAbove = ctx.m_8083_().m_7494_();
        Level level = ctx.m_43725_();
        if (!level.m_8055_(posAbove).m_60629_(ctx)) {
            return null;
        }
        BlockState baseState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        level.m_7731_(posAbove, (BlockState)baseState.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        return baseState;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockPos otherPos;
            BlockState otherState;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof HangingFrameBlockEntity) {
                HangingFrameBlockEntity shelfBlockEntity = (HangingFrameBlockEntity)blockEntity;
                for (ItemStack stack : shelfBlockEntity.getInventory()) {
                    if (stack.m_41619_()) continue;
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)stack);
                }
                level.m_46747_(pos);
            }
            if ((otherState = level.m_8055_(otherPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_())).m_60713_((Block)this)) {
                level.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction == Direction.DOWN && half == DoubleBlockHalf.UPPER && neighborState.m_60734_() != this) {
            return Blocks.f_50016_.m_49966_();
        }
        if (direction == Direction.UP && half == DoubleBlockHalf.LOWER && neighborState.m_60734_() != this) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, pos, neighborPos);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? TOP_SHAPES.get(state.m_61143_((Property)FACING)) : BOTTOM_SHAPES.get(state.m_61143_((Property)FACING));
    }

    @NotNull
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new HangingFrameBlockEntity(pos, state, this.size());
    }

    public int size() {
        return 3;
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof HangingFrameBlockEntity)) {
            return InteractionResult.PASS;
        }
        HangingFrameBlockEntity shelfBlockEntity = (HangingFrameBlockEntity)blockEntity;
        Optional<Tuple<Float, Float>> optional = LilisLuckyLuresUtil.getRelativeHitCoordinatesForBlockFace(hit, (Direction)state.m_61143_((Property)FACING), new Direction[]{Direction.DOWN, Direction.UP});
        if (optional.isEmpty()) {
            return InteractionResult.PASS;
        }
        int i = 2 - (int)(((Float)optional.get().m_14418_()).floatValue() * 3.0f);
        if (i < 0 || i >= shelfBlockEntity.getInventory().size()) {
            return InteractionResult.PASS;
        }
        if (!((ItemStack)shelfBlockEntity.getInventory().get(i)).m_41619_()) {
            if (!world.f_46443_) {
                ItemStack itemStack = shelfBlockEntity.removeStack(i);
                world.m_5594_(null, pos, SoundEvents.f_12642_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (!player.m_150109_().m_36054_(itemStack)) {
                    player.m_36176_(itemStack, false);
                }
                world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_204117_(ItemTags.f_13156_)) {
            if (!world.f_46443_) {
                shelfBlockEntity.setStack(i, stack.m_41620_(1));
                world.m_5594_(null, pos, SoundEvents.f_12641_, SoundSource.BLOCKS, 1.0f, 1.0f);
                if (player.m_7500_()) {
                    stack.m_41769_(1);
                }
                world.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            }
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.CONSUME;
    }

    static {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TOP_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(Direction.NORTH, direction, TOP_SHAPE));
            BOTTOM_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(Direction.NORTH, direction, BOTTOM_SHAPE));
        }
    }
}

