/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.lilis_lucky_lures.core.block.entity.RedstoneCoilBlockEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class RedstoneCoilBlock
extends BaseEntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final EnumProperty<DoubleBlockHalf> HALF = EnumProperty.m_61587_((String)"half", DoubleBlockHalf.class);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<RedstoneCoilTarget> TARGET = EnumProperty.m_61587_((String)"target", RedstoneCoilTarget.class);
    private static final VoxelShape TOP_SHAPE;
    private static final VoxelShape BOTTOM_SHAPE;
    private static final Map<Direction, VoxelShape> TOP_SHAPES;
    private static final Map<Direction, VoxelShape> BOTTOM_SHAPES;
    private static final Random RANDOM;

    public RedstoneCoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(TARGET, (Comparable)((Object)RedstoneCoilTarget.NONE)));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (!level.f_46443_) {
            if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                BlockPos posAbove;
                BlockState stateAbove;
                boolean powered = level.m_276867_(pos);
                if ((Boolean)state.m_61143_((Property)ACTIVE) != powered) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(powered)), 3);
                    BlockEntity be = level.m_7702_(pos);
                    if (be instanceof RedstoneCoilBlockEntity) {
                        RedstoneCoilBlockEntity coil = (RedstoneCoilBlockEntity)be;
                        coil.setActive(powered);
                    }
                }
                if ((stateAbove = level.m_8055_(posAbove = pos.m_7494_())).m_60734_() instanceof RedstoneCoilBlock && stateAbove.m_61143_(HALF) == DoubleBlockHalf.UPPER && (Boolean)stateAbove.m_61143_((Property)ACTIVE) != powered) {
                    level.m_7731_(posAbove, (BlockState)stateAbove.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(powered)), 3);
                    BlockEntity beAbove = level.m_7702_(posAbove);
                    if (beAbove instanceof RedstoneCoilBlockEntity) {
                        RedstoneCoilBlockEntity coilAbove = (RedstoneCoilBlockEntity)beAbove;
                        coilAbove.setActive(powered);
                    }
                }
            } else {
                BlockPos posBelow = pos.m_7495_();
                BlockState stateBelow = level.m_8055_(posBelow);
                if (stateBelow.m_60734_() instanceof RedstoneCoilBlock && stateBelow.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
                    boolean bottomActive = (Boolean)stateBelow.m_61143_((Property)ACTIVE);
                    if ((Boolean)state.m_61143_((Property)ACTIVE) != bottomActive) {
                        level.m_7731_(pos, (BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(bottomActive)), 3);
                        BlockEntity be = level.m_7702_(pos);
                        if (be instanceof RedstoneCoilBlockEntity) {
                            RedstoneCoilBlockEntity coil = (RedstoneCoilBlockEntity)be;
                            coil.setActive(bottomActive);
                        }
                    }
                }
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos posAbove = ctx.m_8083_().m_7494_();
        Level level = ctx.m_43725_();
        if (!level.m_8055_(posAbove).m_60629_(ctx)) {
            return null;
        }
        Direction facing = ctx.m_8125_().m_122424_();
        BlockState baseState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(TARGET, (Comparable)((Object)RedstoneCoilTarget.NONE));
        BlockState upperState = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER)).m_61124_(TARGET, (Comparable)((Object)RedstoneCoilTarget.NONE));
        level.m_7731_(posAbove, upperState, 3);
        return baseState;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockPos otherPos;
        BlockState otherState;
        if (!state.m_60713_(newState.m_60734_()) && (otherState = level.m_8055_(otherPos = state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_())).m_60713_((Block)this)) {
            level.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
            if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
                Block.m_49950_((BlockState)otherState, (Level)level, (BlockPos)pos.m_7495_());
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RedstoneCoilBlockEntity(pos, state);
    }

    @NotNull
    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return RedstoneCoilBlock.m_152132_(blockEntityType, (BlockEntityType)((BlockEntityType)EntityTypeRegistry.REDSTONE_COIL.get()), RedstoneCoilBlockEntity::tick);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ACTIVE, FACING, HALF, TARGET});
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)ACTIVE)).booleanValue() && state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            double centerX = (double)pos.m_123341_() + 0.5;
            double centerY = (double)pos.m_123342_() + 1.5;
            double centerZ = (double)pos.m_123343_() + 0.5;
            DustParticleOptions redDust = new DustParticleOptions(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
            for (int i = 0; i < 2; ++i) {
                double offsetX = (RANDOM.nextDouble() - 0.5) * 0.6;
                double offsetY = RANDOM.nextDouble() * 0.3;
                double offsetZ = (RANDOM.nextDouble() - 0.5) * 0.6;
                level.m_7106_((ParticleOptions)ParticleTypes.f_175830_, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 0.0, 0.0, 0.0);
                level.m_7106_((ParticleOptions)redDust, centerX + offsetX, centerY + offsetY, centerZ + offsetZ, 0.0, 0.0, 0.0);
            }
        }
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos basePos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
        BlockState baseState = level.m_8055_(basePos);
        if (!(baseState.m_60734_() instanceof RedstoneCoilBlock)) {
            return InteractionResult.PASS;
        }
        RedstoneCoilTarget current = (RedstoneCoilTarget)((Object)baseState.m_61143_(TARGET));
        RedstoneCoilTarget next = switch (current) {
            case RedstoneCoilTarget.NONE -> RedstoneCoilTarget.FISHES;
            case RedstoneCoilTarget.FISHES -> RedstoneCoilTarget.PLAYER;
            case RedstoneCoilTarget.PLAYER -> RedstoneCoilTarget.MONSTER;
            default -> RedstoneCoilTarget.NONE;
        };
        level.m_7731_(basePos, (BlockState)baseState.m_61124_(TARGET, (Comparable)((Object)next)), 3);
        return InteractionResult.CONSUME;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity be = level.m_7702_(pos);
            if (be instanceof RedstoneCoilBlockEntity) {
                RedstoneCoilBlockEntity coil = (RedstoneCoilBlockEntity)be;
                coil.setOwner(player.m_20148_());
            }
        }
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? TOP_SHAPES.get(state.m_61143_((Property)FACING)) : BOTTOM_SHAPES.get(state.m_61143_((Property)FACING));
    }

    public void m_5871_(ItemStack itemStack, @Nullable BlockGetter blockGetter, List<Component> list, TooltipFlag tooltipFlag) {
        Style defaultStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)5415884));
        Style actionStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)16772275));
        Style noteStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xDAFFFF));
        if (!Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.shift_to_show_more").m_6270_(actionStyle).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.information").m_6270_(defaultStyle)));
        } else {
            list.add((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.description.defense").m_6270_(defaultStyle));
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.right_click_to_switch").m_6270_(actionStyle).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.modes").m_6270_(defaultStyle)));
            list.add((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.mode.none").m_6270_(noteStyle).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.mode.none.description").m_6270_(defaultStyle)));
            list.add((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.mode.player").m_6270_(noteStyle).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.mode.player.description").m_6270_(defaultStyle)));
            list.add((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.mode.fishes").m_6270_(noteStyle).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.mode.fishes.description").m_6270_(defaultStyle)));
            list.add((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.mode.monster").m_6270_(noteStyle).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.mode.monster.description").m_6270_(defaultStyle)));
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.note").m_6270_(noteStyle).m_7220_((Component)Component.m_237115_((String)"tooltip.lilis_lucky_lures.block.note.description").m_6270_(defaultStyle)));
        }
    }

    static {
        TOP_SHAPES = new HashMap<Direction, VoxelShape>();
        BOTTOM_SHAPES = new HashMap<Direction, VoxelShape>();
        RANDOM = new Random();
        VoxelShape shape = Shapes.m_83048_((double)0.4375, (double)0.0, (double)0.4375, (double)0.5625, (double)0.875, (double)0.5625);
        TOP_SHAPE = shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.5, (double)0.1875, (double)0.8125, (double)0.75, (double)0.8125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83048_((double)0.4375, (double)0.875, (double)0.4375, (double)0.5625, (double)1.0, (double)0.5625);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.875, (double)0.875, (double)0.875, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.125, (double)0.0, (double)0.125, (double)0.875, (double)0.875, (double)0.875), (BooleanOp)BooleanOp.f_82695_);
        BOTTOM_SHAPE = shape = Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.25, (double)0.25, (double)0.0625, (double)0.75, (double)0.75, (double)0.125), (BooleanOp)BooleanOp.f_82695_);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            TOP_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(Direction.NORTH, direction, TOP_SHAPE));
            BOTTOM_SHAPES.put(direction, LilisLuckyLuresUtil.rotateShape(Direction.NORTH, direction, BOTTOM_SHAPE));
        }
    }

    public static enum RedstoneCoilTarget implements StringRepresentable
    {
        NONE("none"),
        FISHES("fishes"),
        PLAYER("player"),
        MONSTER("monster");

        private final String name;

        private RedstoneCoilTarget(String name) {
            this.name = name;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }
    }
}

