/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;

public class FloatingDebrisEntity
extends Entity {
    private static final int MAX_INTERACTIONS = 3;
    private static final float DESTRUCTION_SPEED = 0.05f;
    private static final EntityDataAccessor<Boolean> IS_DESTROYING = SynchedEntityData.m_135353_(FloatingDebrisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DESTRUCTION_PROGRESS = SynchedEntityData.m_135353_(FloatingDebrisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> HURT_TIME = SynchedEntityData.m_135353_(FloatingDebrisEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final float randomRotation;
    private int interactions = 0;
    private int lifeTicks;
    private int maxLifeTicks;

    public FloatingDebrisEntity(EntityType<? extends FloatingDebrisEntity> type, Level level) {
        super(type, level);
        Random random = new Random();
        this.m_20011_(this.m_20191_().m_82386_(0.0, 1.0, 0.0));
        this.randomRotation = random.nextFloat() * 360.0f;
        this.lifeTicks = 0;
        this.maxLifeTicks = 9600;
        if (!this.m_9236_().f_46443_) {
            this.spawnPlacementParticles();
        }
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(IS_DESTROYING, (Object)false);
        this.f_19804_.m_135372_(DESTRUCTION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HURT_TIME, (Object)0);
    }

    public void m_8119_() {
        int currentHurtTime;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.lifeTicks;
            if (this.lifeTicks >= this.maxLifeTicks) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                return;
            }
        }
        if (this.m_9236_().f_46443_ && this.lifeTicks % 120 == 0) {
            this.spawnPeriodicParticles();
        }
        if ((currentHurtTime = ((Integer)this.f_19804_.m_135370_(HURT_TIME)).intValue()) > 0) {
            this.f_19804_.m_135381_(HURT_TIME, (Object)(currentHurtTime - 1));
        }
        if (!this.m_9236_().f_46443_ && !this.isAboveWater()) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (((Boolean)this.f_19804_.m_135370_(IS_DESTROYING)).booleanValue()) {
            float currentProgress = ((Float)this.f_19804_.m_135370_(DESTRUCTION_PROGRESS)).floatValue();
            this.f_19804_.m_135381_(DESTRUCTION_PROGRESS, (Object)Float.valueOf(currentProgress += 0.05f));
            if (currentProgress >= 1.0f) {
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    public float getRandomRotation() {
        return this.randomRotation;
    }

    private boolean isAboveWater() {
        return this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60819_().m_76170_();
    }

    protected void m_7378_(CompoundTag compound) {
        this.interactions = compound.m_128451_("Interactions");
        boolean destroying = compound.m_128471_("IsDestroying");
        float progress = compound.m_128457_("DestructionProgress");
        this.f_19804_.m_135381_(IS_DESTROYING, (Object)destroying);
        this.f_19804_.m_135381_(DESTRUCTION_PROGRESS, (Object)Float.valueOf(progress));
        this.f_19804_.m_135381_(HURT_TIME, (Object)compound.m_128451_("HurtTime"));
        this.lifeTicks = compound.m_128451_("LifeTicks");
        this.maxLifeTicks = compound.m_128451_("MaxLifeTicks");
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128405_("Interactions", this.interactions);
        compound.m_128379_("IsDestroying", ((Boolean)this.f_19804_.m_135370_(IS_DESTROYING)).booleanValue());
        compound.m_128350_("DestructionProgress", ((Float)this.f_19804_.m_135370_(DESTRUCTION_PROGRESS)).floatValue());
        compound.m_128405_("HurtTime", ((Integer)this.f_19804_.m_135370_(HURT_TIME)).intValue());
        compound.m_128405_("LifeTicks", this.lifeTicks);
        compound.m_128405_("MaxLifeTicks", this.maxLifeTicks);
    }

    public void triggerHurt() {
        this.f_19804_.m_135381_(HURT_TIME, (Object)10);
        if (!this.m_9236_().f_46443_) {
            this.maxLifeTicks += 2400;
        }
    }

    public LootTable getLootTable(ServerLevel serverLevel) {
        return serverLevel.m_7654_().m_278653_().m_278676_((ResourceLocation)new LilisLuckyLuresIdentifier("gameplay/fishing_pools/floating_debris"));
    }

    public void onFishHookInteract(Player player) {
        Level level;
        if (!this.m_9236_().f_46443_ && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootTable lootTable = this.getLootTable(serverLevel);
            LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81458_, (Object)player).m_287286_(LootContextParams.f_81457_, (Object)serverLevel.m_269111_().m_269264_()).m_287235_(LootContextParamSets.f_81415_);
            ObjectArrayList loot = lootTable.m_287195_(lootParams);
            loot.forEach(arg_0 -> ((Player)player).m_36356_(arg_0));
            this.triggerHurt();
            ++this.interactions;
            if (this.interactions >= 3) {
                this.removeWithEffects(serverLevel);
            }
        }
    }

    public void removeWithEffects(ServerLevel serverLevel) {
        double zOffset;
        int i;
        serverLevel.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_215700_, SoundSource.BLOCKS, 1.0f, 1.0f);
        for (i = 0; i < 35; ++i) {
            double yOffset = serverLevel.f_46441_.m_188500_() * 15.0;
            double xOffset = 0.25 * (serverLevel.f_46441_.m_188500_() - 0.5);
            zOffset = 0.25 * (serverLevel.f_46441_.m_188500_() - 0.5);
            double velocityY = 0.1 + serverLevel.f_46441_.m_188500_() * 0.2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + xOffset + 0.5, this.m_20186_() + yOffset, this.m_20189_() + zOffset + 0.5, 1, 0.0, velocityY, 0.0, 0.0);
        }
        for (i = 0; i < 18; ++i) {
            double xOffset = serverLevel.f_46441_.m_188583_() * 0.2;
            double yOffset = serverLevel.f_46441_.m_188583_() * 0.2;
            zOffset = serverLevel.f_46441_.m_188583_() * 0.2;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123772_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 20, xOffset, yOffset, zOffset, 0.1);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 10, xOffset, yOffset, zOffset, 0.1);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 5, xOffset, yOffset, zOffset, 0.1);
        }
        this.f_19804_.m_135381_(IS_DESTROYING, (Object)true);
    }

    public int getHurtTime() {
        return (Integer)this.f_19804_.m_135370_(HURT_TIME);
    }

    public void triggerInteraction() {
        ++this.interactions;
        this.triggerHurt();
        if (this.interactions >= 3 && !this.m_9236_().f_46443_) {
            this.removeWithEffects((ServerLevel)this.m_9236_());
        }
    }

    private void spawnPlacementParticles() {
        for (int i = 0; i < 10; ++i) {
            double xOffset = this.f_19796_.m_188500_() - 0.5;
            double zOffset = this.f_19796_.m_188500_() - 0.5;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() + xOffset, this.m_20186_() + 1.9, this.m_20189_() + zOffset, 0.0, 0.1, 0.0);
        }
    }

    private void spawnPeriodicParticles() {
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, x, this.m_20186_() + 1.8, z, 0.0, 0.05, 0.0);
    }

    @NotNull
    public AABB m_6921_() {
        return new AABB(this.m_20185_() - 1.0, this.m_20186_() - 1.0, this.m_20189_() - 1.0, this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0);
    }
}

