/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.entity.projectile;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrownSpearEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownSpearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack spearItem;
    private boolean dealtDamage;
    public int clientSideReturnSpearTickCount;

    public ThrownSpearEntity(EntityType<? extends ThrownSpearEntity> entityType, Level level) {
        super(entityType, level);
        this.spearItem = new ItemStack((ItemLike)ObjectRegistry.SPEAR.get());
    }

    public ThrownSpearEntity(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        super((EntityType)EntityTypeRegistry.THROWN_SPEAR.get(), livingEntity, level);
        this.spearItem = itemStack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)itemStack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)itemStack.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.m_20011_(new AABB(-0.25, -0.25, -0.25, 0.25, 0.25, 0.25));
    }

    @NotNull
    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20398_((float)0.5f, (float)0.5f);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        byte loyaltyLevel = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (loyaltyLevel > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 ownerPos = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + ownerPos.f_82480_ * 0.015 * (double)loyaltyLevel, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double speed = 0.05 * (double)loyaltyLevel;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(ownerPos.m_82541_().m_82490_(speed)));
                if (this.clientSideReturnSpearTickCount == 0) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                ++this.clientSideReturnSpearTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity owner = this.m_19749_();
        return owner != null && owner.m_6084_() && (!(owner instanceof ServerPlayer) || !owner.m_5833_());
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.spearItem.m_41777_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 startVec, Vec3 endVec) {
        return this.dealtDamage ? null : super.m_6351_(startVec, endVec);
    }

    protected void m_5790_(EntityHitResult result) {
        Entity target = result.m_82443_();
        float damage = 8.0f;
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.spearItem, (MobType)livingTarget.m_6336_());
            if (livingTarget.m_20069_()) {
                damage *= 1.35f;
            }
        }
        Entity owner = this.m_19749_();
        DamageSource damageSource = this.m_269291_().m_269525_((Entity)this, (Entity)(owner == null ? this : owner));
        this.dealtDamage = true;
        SoundEvent sound = SoundEvents.f_12514_;
        if (target.m_6469_(damageSource, damage) && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (target.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (owner instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)owner;
                EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)livingOwner);
                EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingTarget);
            }
            this.m_7761_(livingTarget);
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float pitch = 1.0f;
        this.m_5496_(sound, pitch, 1.0f);
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_19749_() == null) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("Spear", 10)) {
            this.spearItem = ItemStack.m_41712_((CompoundTag)tag.m_128469_("Spear"));
        }
        this.dealtDamage = tag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.spearItem)));
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Spear", (Tag)this.spearItem.m_41739_(new CompoundTag()));
        tag.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || (Byte)this.f_19804_.m_135370_(ID_LOYALTY) <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double cameraX, double cameraY, double cameraZ) {
        return true;
    }
}

