/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.item;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;
import org.jetbrains.annotations.NotNull;

public class FishingNetItem
extends Item {
    private static final float SUCCESS_CHANCE = 0.8f;
    private static final int USE_DURATION = 100;
    private static final int COOLDOWN_TICKS = 40;
    private static final String TAG_STATE = "State";
    private static final String TAG_ENTITY_LOOT = "EntityLoot";
    private static final int STATE_EMPTY = 0;
    private static final int STATE_FULL = 1;

    public FishingNetItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int state = this.getState(stack);
        if (state == 0) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!level.f_46443_) {
            this.retrieveLoot(level, player, stack);
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_5929_(Level level, LivingEntity entity, ItemStack stack, int remainingUseTicks) {
        if (!level.f_46443_ && entity instanceof Player) {
            FloatingDebrisEntity targetDebris;
            Player player = (Player)entity;
            if (this.getState(stack) == 0 && (targetDebris = this.getTargetDebris(level, player)) != null) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnParticles(serverLevel, targetDebris.m_20185_(), targetDebris.m_20186_() + 0.5, targetDebris.m_20189_());
                if (remainingUseTicks % 20 == 0) {
                    level.m_6263_(null, targetDebris.m_20185_(), targetDebris.m_20186_(), targetDebris.m_20189_(), SoundEvents.f_11707_, SoundSource.NEUTRAL, 1.25f, 1.0f);
                }
            }
        }
    }

    @NotNull
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity entity) {
        if (!level.f_46443_ && entity instanceof Player) {
            FloatingDebrisEntity targetDebris;
            Player player = (Player)entity;
            if (this.getState(stack) == 0 && (targetDebris = this.getTargetDebris(level, player)) != null) {
                if (level.m_213780_().m_188501_() <= 0.8f) {
                    this.setState(stack, 1);
                    LootTable entityLootTable = targetDebris.getLootTable((ServerLevel)level);
                    LootParams lootParams = new LootParams.Builder((ServerLevel)level).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81416_);
                    ObjectArrayList entityLoot = entityLootTable.m_287195_(lootParams);
                    CompoundTag tag = stack.m_41784_();
                    ListTag lootListTag = new ListTag();
                    for (ItemStack item : entityLoot) {
                        CompoundTag itemTag = new CompoundTag();
                        item.m_41739_(itemTag);
                        lootListTag.add((Object)itemTag);
                    }
                    tag.m_128365_(TAG_ENTITY_LOOT, (Tag)lootListTag);
                    stack.m_41751_(tag);
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11918_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    targetDebris.triggerInteraction();
                } else {
                    level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11917_, SoundSource.PLAYERS, 0.5f, 0.8f);
                }
                player.m_36335_().m_41524_((Item)this, 40);
            }
        }
        return stack;
    }

    private void retrieveLoot(Level level, Player player, ItemStack stack) {
        ServerLevel serverLevel = (ServerLevel)level;
        LootTable fishingNetLootTable = serverLevel.m_7654_().m_278653_().m_278676_((ResourceLocation)new LilisLuckyLuresIdentifier("gameplay/fishing_net"));
        LootParams fishingNetLootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81455_, (Object)player).m_287286_(LootContextParams.f_81460_, (Object)player.m_20182_()).m_287235_(LootContextParamSets.f_81416_);
        ObjectArrayList fishingNetLoot = fishingNetLootTable.m_287195_(fishingNetLootParams);
        fishingNetLoot.forEach(arg_0 -> ((Player)player).m_36356_(arg_0));
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(TAG_ENTITY_LOOT, 9)) {
            ListTag lootListTag = tag.m_128437_(TAG_ENTITY_LOOT, 10);
            for (int i = 0; i < lootListTag.size(); ++i) {
                CompoundTag itemTag = lootListTag.m_128728_(i);
                ItemStack entityLootItem = ItemStack.m_41712_((CompoundTag)itemTag);
                player.m_36356_(entityLootItem);
            }
            tag.m_128473_(TAG_ENTITY_LOOT);
        }
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 1.0f, 1.0f);
        this.setState(stack, 0);
    }

    private FloatingDebrisEntity getTargetDebris(Level level, Player player) {
        List debris = level.m_45976_(FloatingDebrisEntity.class, player.m_20191_().m_82400_(1.0));
        return debris.stream().filter(entity -> this.isInSight(player, (FloatingDebrisEntity)((Object)entity))).min(Comparator.comparingDouble(arg_0 -> ((Player)player).m_20270_(arg_0))).orElse(null);
    }

    private boolean isInSight(Player player, FloatingDebrisEntity entity) {
        Vec3 toEntity;
        Vec3 lookVec = player.m_20154_();
        double dot = lookVec.m_82526_(toEntity = entity.m_20182_().m_82546_(player.m_146892_()).m_82541_());
        return dot > 0.7;
    }

    private void spawnParticles(ServerLevel serverLevel, double x, double y, double z) {
        RandomSource random = serverLevel.m_213780_();
        for (int i = 0; i < 15; ++i) {
            double offsetX = (random.m_188500_() - 0.5) * 1.5;
            double offsetY = random.m_188500_() + 0.5;
            double offsetZ = (random.m_188500_() - 0.5) * 1.5;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123795_, x + offsetX, y + offsetY, z + offsetZ, 2, 0.0, 0.05, 0.0, 0.01);
        }
    }

    public int m_8105_(ItemStack stack) {
        return 100;
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BRUSH;
    }

    private int getState(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_(TAG_STATE)) {
            return tag.m_128451_(TAG_STATE);
        }
        return 0;
    }

    private void setState(ItemStack stack, int state) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TAG_STATE, state);
        if (state == 1) {
            tag.m_128405_("CustomModelData", 1);
        } else {
            tag.m_128473_("CustomModelData");
        }
        stack.m_41751_(tag);
    }
}

