/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.mixin;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin {
    @Inject(method={"shouldStopFishing"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectedShouldStopFishing(Player player, CallbackInfoReturnable<Boolean> cir) {
        ItemStack mainHandStack = player.m_21205_();
        ItemStack offHandStack = player.m_21206_();
        boolean isUsingMainHand = mainHandStack.m_150930_((Item)ObjectRegistry.BAMBOO_FISHING_ROD.get());
        boolean isUsingOffHand = offHandStack.m_150930_((Item)ObjectRegistry.BAMBOO_FISHING_ROD.get());
        if (isUsingMainHand || isUsingOffHand) {
            FishingHook fishingHook = (FishingHook)this;
            if (!player.m_213877_() && player.m_6084_() && fishingHook.m_20280_((Entity)player) <= 1024.0) {
                cir.setReturnValue((Object)false);
            } else {
                fishingHook.m_146870_();
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"retrieve"}, at={@At(value="TAIL")})
    private void onRetrieve(ItemStack itemStack, CallbackInfoReturnable<Integer> cir) {
        int returnValue;
        Player owner;
        FishingHook fishingHook = (FishingHook)this;
        if (!fishingHook.m_9236_().f_46443_ && (owner = fishingHook.m_37168_()) != null && (returnValue = ((Integer)cir.getReturnValue()).intValue()) > 0) {
            Vec3 hookPosition = fishingHook.m_20182_();
            AABB hookBoundingBox = new AABB(hookPosition.f_82479_ - 1.0, hookPosition.f_82480_ - 1.0, hookPosition.f_82481_ - 1.0, hookPosition.f_82479_ + 1.0, hookPosition.f_82480_ + 1.0, hookPosition.f_82481_ + 1.0);
            List debrisEntities = fishingHook.m_9236_().m_45976_(FloatingDebrisEntity.class, hookBoundingBox);
            if (!debrisEntities.isEmpty()) {
                FloatingDebrisEntity debrisEntity = (FloatingDebrisEntity)((Object)debrisEntities.get(0));
                debrisEntity.onFishHookInteract(owner);
            }
        }
    }
}

