/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Random;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.lilis_lucky_lures.core.registry.RecipeTypeRegistry;
import org.jetbrains.annotations.NotNull;

public class FishTrapRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final Ingredient baitItem;
    private final ItemStack catchItem;
    private final int catchCount;
    private final int minDuration;
    private final int maxDuration;
    private final Random random = new Random();

    public FishTrapRecipe(ResourceLocation id, Ingredient baitItem, ItemStack catchItem, int catchCount, int minDuration, int maxDuration) {
        this.id = id;
        this.baitItem = baitItem;
        this.catchItem = catchItem;
        this.catchCount = catchCount;
        this.minDuration = minDuration;
        this.maxDuration = maxDuration;
    }

    public Ingredient getBaitItem() {
        return this.baitItem;
    }

    public ItemStack getCatchItem() {
        return this.catchItem.m_41777_();
    }

    public int getCatchCount() {
        return this.catchCount;
    }

    public int getRandomDuration() {
        return this.minDuration + this.random.nextInt(this.maxDuration - this.minDuration + 1);
    }

    public int getMinDuration() {
        return this.minDuration;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonNullList = NonNullList.m_122779_();
        nonNullList.add((Object)this.baitItem);
        return nonNullList;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return this.baitItem.test(inventory.m_8020_(0));
    }

    @NotNull
    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.catchItem.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.catchItem.m_41777_();
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.FISH_TRAP_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.FISH_TRAP_RECIPE_TYPE.get();
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Serializer
    implements RecipeSerializer<FishTrapRecipe> {
        @NotNull
        public FishTrapRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient baitItem = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"bait_item"));
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"catch").getAsJsonObject("result");
            ItemStack catchItem = ShapedRecipe.m_151274_((JsonObject)result);
            int catchCount = GsonHelper.m_13824_((JsonObject)result, (String)"count", (int)1);
            JsonObject duration = GsonHelper.m_13930_((JsonObject)json, (String)"catch_duration");
            int minDuration = GsonHelper.m_13927_((JsonObject)duration, (String)"min");
            int maxDuration = GsonHelper.m_13927_((JsonObject)duration, (String)"max");
            return new FishTrapRecipe(id, baitItem, catchItem, catchCount, minDuration, maxDuration);
        }

        @NotNull
        public FishTrapRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            Ingredient baitItem = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack catchItem = buf.m_130267_();
            int catchCount = buf.readInt();
            int minDuration = buf.readInt();
            int maxDuration = buf.readInt();
            return new FishTrapRecipe(id, baitItem, catchItem, catchCount, minDuration, maxDuration);
        }

        public void toNetwork(FriendlyByteBuf buf, FishTrapRecipe recipe) {
            recipe.baitItem.m_43923_(buf);
            buf.m_130055_(recipe.catchItem);
            buf.writeInt(recipe.catchCount);
            buf.writeInt(recipe.minDuration);
            buf.writeInt(recipe.maxDuration);
        }
    }
}

