/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.lilis_lucky_lures.core.block.entity.CompletionistBannerEntity;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrapBlockEntity;
import net.satisfy.lilis_lucky_lures.core.block.entity.FishTrophyFrameBlockEntity;
import net.satisfy.lilis_lucky_lures.core.block.entity.HangingFrameBlockEntity;
import net.satisfy.lilis_lucky_lures.core.block.entity.RedstoneCoilBlockEntity;
import net.satisfy.lilis_lucky_lures.core.entity.DynamiteEntity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingBooksEntity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.entity.OceanFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.entity.RiverFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.entity.projectile.ThrownSpearEntity;
import net.satisfy.lilis_lucky_lures.core.registry.ObjectRegistry;
import net.satisfy.lilis_lucky_lures.core.util.LilisLuckyLuresIdentifier;

public class EntityTypeRegistry {
    private static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"lilis_lucky_lures", (ResourceKey)Registries.f_256922_);
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"lilis_lucky_lures", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<DynamiteEntity>> DYNAMITE = EntityTypeRegistry.registerEntityType("dynamite", () -> EntityType.Builder.m_20704_(DynamiteEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new LilisLuckyLuresIdentifier("dynamite").toString()));
    public static final RegistrySupplier<EntityType<ThrownSpearEntity>> THROWN_SPEAR = EntityTypeRegistry.registerEntityType("thrown_spear", () -> EntityType.Builder.m_20704_(ThrownSpearEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20712_(new LilisLuckyLuresIdentifier("thrown_spear").toString()));
    public static final RegistrySupplier<EntityType<FloatingDebrisEntity>> FLOATING_DEBRIS = EntityTypeRegistry.registerEntityType("floating_debris", () -> EntityType.Builder.m_20704_(FloatingDebrisEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(2.0f, 2.5f).m_20712_(new LilisLuckyLuresIdentifier("floating_debris").toString()));
    public static final RegistrySupplier<EntityType<FloatingBooksEntity>> FLOATING_BOOKS = EntityTypeRegistry.registerEntityType("floating_books", () -> EntityType.Builder.m_20704_(FloatingBooksEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(2.0f, 2.5f).m_20712_(new LilisLuckyLuresIdentifier("floating_books").toString()));
    public static final RegistrySupplier<EntityType<RiverFishPoolEntity>> RIVER_FISH_POOL = EntityTypeRegistry.registerEntityType("river_fish_pool", () -> EntityType.Builder.m_20704_(RiverFishPoolEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(2.0f, 2.5f).m_20712_(new LilisLuckyLuresIdentifier("river_fish_pool").toString()));
    public static final RegistrySupplier<EntityType<OceanFishPoolEntity>> OCEAN_FISH_POOL = EntityTypeRegistry.registerEntityType("ocean_fish_pool", () -> EntityType.Builder.m_20704_(OceanFishPoolEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(2.0f, 2.5f).m_20712_(new LilisLuckyLuresIdentifier("ocean_fish_pool").toString()));
    public static final RegistrySupplier<BlockEntityType<FishTrapBlockEntity>> FISH_TRAP = EntityTypeRegistry.registerBlockEntity("fish_trap", () -> BlockEntityType.Builder.m_155273_(FishTrapBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FISH_TRAP.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<HangingFrameBlockEntity>> HANGING_FRAME = EntityTypeRegistry.registerBlockEntity("hanging_frame", () -> BlockEntityType.Builder.m_155273_(HangingFrameBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.HANGING_FRAME.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<RedstoneCoilBlockEntity>> REDSTONE_COIL = EntityTypeRegistry.registerBlockEntity("redstone_coil", () -> BlockEntityType.Builder.m_155273_(RedstoneCoilBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.REDSTONE_COIL.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FishTrophyFrameBlockEntity>> FISH_TROPHY_FRAME = EntityTypeRegistry.registerBlockEntity("fishing_trophy_frame", () -> BlockEntityType.Builder.m_155273_(FishTrophyFrameBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.FISH_TROPHY_FRAME.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> LILIS_LUCKY_LURES_BANNER = EntityTypeRegistry.registerBlockEntity("lilis_lucky_lures_banner", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LILIS_LUCKY_LURES_BANNER.get(), (Block)ObjectRegistry.LILIS_LUCKY_LURES_WALL_BANNER.get()}).m_58966_(null));

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String name, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new LilisLuckyLuresIdentifier(name), type);
    }

    private static <T extends EntityType<?>> RegistrySupplier<T> registerEntityType(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new LilisLuckyLuresIdentifier(path), type);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
    }
}

