/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.core.util;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingBooksEntity;
import net.satisfy.lilis_lucky_lures.core.entity.FloatingDebrisEntity;
import net.satisfy.lilis_lucky_lures.core.entity.OceanFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.entity.RiverFishPoolEntity;
import net.satisfy.lilis_lucky_lures.core.registry.EntityTypeRegistry;
import org.joml.Vector3d;

public class FloatingPoolsSpawner {
    private static final int MAX_COUNT = 3;
    private static final int SPAWN_INTERVAL = 6000;
    private static BlockPos lastValidSpawn = null;
    private static long lastSpawnTime = 0L;

    private static void attemptSpawn(ServerLevel level) {
        if (level.m_6907_().isEmpty()) {
            return;
        }
        RandomSource random = level.f_46441_;
        ServerPlayer player = (ServerPlayer)level.m_6907_().get(random.m_188503_(level.m_6907_().size()));
        if (lastValidSpawn == null || level.m_46467_() - lastSpawnTime > 12000L) {
            lastValidSpawn = FloatingPoolsSpawner.findValidSpawnPos(level, player.m_20183_());
            lastSpawnTime = level.m_46467_();
        }
        if (lastValidSpawn == null) {
            return;
        }
        int spawnX = lastValidSpawn.m_123341_();
        int spawnY = lastValidSpawn.m_123342_();
        int spawnZ = lastValidSpawn.m_123343_();
        AABB area = new AABB((double)(spawnX - 128), (double)(spawnY - 128), (double)(spawnZ - 128), (double)(spawnX + 128), (double)(spawnY + 128), (double)(spawnZ + 128));
        int totalCount = level.m_45976_(FloatingDebrisEntity.class, area).size();
        totalCount += level.m_45976_(FloatingBooksEntity.class, area).size();
        Holder biome = level.m_204166_(lastValidSpawn);
        if (biome.m_203656_(BiomeTags.f_207603_)) {
            totalCount += level.m_45976_(OceanFishPoolEntity.class, area).size();
        } else if (biome.m_203656_(BiomeTags.f_207605_)) {
            totalCount += level.m_45976_(RiverFishPoolEntity.class, area).size();
        }
        if (totalCount >= 3) {
            return;
        }
        ArrayList<Runnable> actions = new ArrayList<Runnable>();
        AABB smallArea = new AABB((double)(spawnX - 50), (double)(spawnY - 50), (double)(spawnZ - 50), (double)(spawnX + 50), (double)(spawnY + 50), (double)(spawnZ + 50));
        if (level.m_45976_(FloatingDebrisEntity.class, smallArea).size() < 3) {
            actions.add(() -> {
                FloatingDebrisEntity debris = new FloatingDebrisEntity((EntityType<? extends FloatingDebrisEntity>)((EntityType)EntityTypeRegistry.FLOATING_DEBRIS.get()), (Level)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                debris.m_6034_(spawnPos.x, spawnPos.y, spawnPos.z);
                level.m_7967_((Entity)debris);
            });
        }
        if (biome.m_203656_(BiomeTags.f_207603_)) {
            actions.add(() -> {
                OceanFishPoolEntity ocean = new OceanFishPoolEntity((EntityType<? extends OceanFishPoolEntity>)((EntityType)EntityTypeRegistry.OCEAN_FISH_POOL.get()), (Level)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                ocean.m_6034_(spawnPos.x, spawnPos.y, spawnPos.z);
                level.m_7967_((Entity)ocean);
            });
        } else if (biome.m_203656_(BiomeTags.f_207605_)) {
            actions.add(() -> {
                RiverFishPoolEntity river = new RiverFishPoolEntity((EntityType<? extends RiverFishPoolEntity>)((EntityType)EntityTypeRegistry.RIVER_FISH_POOL.get()), (Level)level);
                Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
                river.m_6034_(spawnPos.x, spawnPos.y, spawnPos.z);
                level.m_7967_((Entity)river);
            });
        }
        actions.add(() -> {
            FloatingBooksEntity books = new FloatingBooksEntity((EntityType<? extends FloatingBooksEntity>)((EntityType)EntityTypeRegistry.FLOATING_BOOKS.get()), (Level)level);
            Vector3d spawnPos = new Vector3d((double)spawnX + 0.5, (double)spawnY, (double)spawnZ + 0.5);
            books.m_6034_(spawnPos.x, spawnPos.y, spawnPos.z);
            level.m_7967_((Entity)books);
        });
        ((Runnable)actions.get(random.m_188503_(actions.size()))).run();
    }

    private static BlockPos findValidSpawnPos(ServerLevel level, BlockPos center) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < 10; ++i) {
            int offsetZ;
            int offsetX = random.m_188503_(200) - 100;
            BlockPos newPos = center.m_7918_(offsetX, 0, offsetZ = random.m_188503_(200) - 100);
            Holder biome = level.m_204166_(newPos);
            if (!biome.m_203656_(BiomeTags.f_207605_) && !biome.m_203656_(BiomeTags.f_207603_)) continue;
            int spawnY = level.m_6924_(Heightmap.Types.WORLD_SURFACE, newPos.m_123341_(), newPos.m_123343_()) - 2;
            return new BlockPos(newPos.m_123341_(), spawnY, newPos.m_123343_());
        }
        return null;
    }

    public static void tick(ServerLevel level) {
        if (level.m_46467_() % 6000L == 0L) {
            FloatingPoolsSpawner.attemptSpawn(level);
        }
    }
}

