/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.lilis_lucky_lures.platform.forge;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.jetbrains.annotations.Nullable;

public class PlatformHelperImpl {
    public static <T extends Recipe<?>> T fromJson(ResourceLocation recipeId, JsonObject json) {
        JsonObject recipe = GsonHelper.m_13930_((JsonObject)json, (String)"recipe");
        JsonArray conditions = GsonHelper.m_13933_((JsonObject)json, (String)"conditions");
        JsonObject forgeRecipe = new JsonObject();
        forgeRecipe.addProperty("type", "forge:conditional");
        JsonArray recipes = new JsonArray();
        JsonObject newRecipe = new JsonObject();
        newRecipe.add("conditions", (JsonElement)conditions);
        newRecipe.add("recipe", (JsonElement)recipe);
        recipes.add((JsonElement)newRecipe);
        forgeRecipe.add("recipes", (JsonElement)recipes);
        return (T)ConditionalRecipe.SERIALZIER.m_6729_(recipeId, forgeRecipe);
    }

    public static boolean isModLoaded(String modid) {
        ModList modList = ModList.get();
        if (modList != null) {
            return modList.isLoaded(modid);
        }
        return PlatformHelperImpl.isModPreLoaded(modid);
    }

    public static boolean isModPreLoaded(String modid) {
        return PlatformHelperImpl.getPreLoadedModInfo(modid) != null;
    }

    @Nullable
    public static ModInfo getPreLoadedModInfo(String modId) {
        for (ModInfo info : LoadingModList.get().getMods()) {
            if (!info.getModId().equals(modId)) continue;
            return info;
        }
        return null;
    }
}

