/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.components.machines;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.teamresourceful.resourcefullib.client.components.CursorWidget;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.screens.CursorScreen;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import com.teamresourceful.resourcefullib.common.network.Packet;
import earth.terrarium.adastra.client.components.base.TickableWidget;
import earth.terrarium.adastra.client.components.machines.ConfigurationWidget;
import earth.terrarium.adastra.client.screens.base.ConfigurationScreen;
import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.configuration.FluidConfiguration;
import earth.terrarium.adastra.common.network.NetworkHandler;
import earth.terrarium.adastra.common.network.messages.ServerboundClearFluidTankPacket;
import earth.terrarium.adastra.common.utils.TooltipUtils;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;

public class FluidBarWidget
extends ConfigurationWidget
implements CursorWidget,
TickableWidget {
    protected final BlockPos tankPos;
    protected final int tank;
    protected final FluidContainer container;
    protected long lastFluidAmount;
    protected long difference;

    public FluidBarWidget(BlockPos tankPos, FluidConfiguration configuration) {
        super(configuration, 12, 46);
        this.tankPos = tankPos;
        this.tank = configuration.tank();
        this.container = configuration.container();
    }

    @Override
    public void tick() {
        FluidHolder holder = (FluidHolder)this.container.getFluids().get(this.tank);
        this.difference = holder.getFluidAmount() - this.lastFluidAmount;
        this.lastFluidAmount = holder.getFluidAmount();
    }

    protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        FluidHolder holder = (FluidHolder)this.container.getFluids().get(this.tank);
        long capacity = this.container.getTankCapacity(this.tank);
        long amount = holder.getFluidAmount();
        float ratio = (float)amount / (float)capacity;
        int x = this.m_252754_();
        int y = this.m_252907_();
        if (!holder.isEmpty()) {
            TextureAtlasSprite sprite = ClientFluidHooks.getFluidSprite((FluidHolder)holder);
            int color = ClientFluidHooks.getFluidColor((FluidHolder)holder);
            float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
            float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
            float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
            try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Minecraft.m_91087_(), (PoseStack)graphics.m_280168_(), (int)x, (int)(y + 46 - (int)(46.0f * ratio)), (int)12, (int)46);){
                for (int i = 1; i < 5; ++i) {
                    graphics.m_280565_(x, y + 46 - i * 16, 0, 16, 16, sprite, r, g, b, 1.0f);
                }
            }
        }
        RenderSystem.enableBlend();
        graphics.m_280163_(GuiUtils.FLUID_BAR, x, y, 0.0f, 0.0f, 12, 46, 12, 46);
        RenderSystem.disableBlend();
        if (this.m_198029_()) {
            if (holder.isEmpty()) {
                this.m_257544_(Tooltip.m_257550_((Component)CommonComponents.m_178396_((Component[])new Component[]{TooltipUtils.getFluidComponent(holder, capacity), TooltipUtils.getFluidDifferenceComponent(this.difference)})));
            } else {
                this.m_257544_(Tooltip.m_257550_((Component)CommonComponents.m_178396_((Component[])new Component[]{TooltipUtils.getFluidComponent(holder, capacity), TooltipUtils.getFluidDifferenceComponent(this.difference), ConstantComponents.CLEAR_FLUID_TANK})));
            }
        }
    }

    @Override
    protected boolean m_7972_(int button) {
        return super.m_7972_(button) || button == 1 && Screen.m_96638_();
    }

    @Override
    public void m_5716_(double mouseX, double mouseY) {
        if (ConfigurationScreen.isConfigurable()) {
            super.m_5716_(mouseX, mouseY);
        } else {
            NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundClearFluidTankPacket(this.tankPos, this.tank));
        }
    }

    public CursorScreen.Cursor getCursor() {
        return Screen.m_96638_() ? CursorScreen.Cursor.POINTER : CursorScreen.Cursor.DEFAULT;
    }
}

