/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.WaterPumpMenu;
import earth.terrarium.adastra.common.registry.ModParticleTypes;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidConstants;
import earth.terrarium.botarium.common.fluid.base.BotariumFluidBlock;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.ExtractOnlyFluidContainer;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;

public class WaterPumpBlockEntity
extends EnergyContainerMachineBlockEntity
implements BotariumFluidBlock<WrappedBlockFluidContainer> {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY), new ConfigurationEntry(ConfigurationType.FLUID, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_FLUID));
    private WrappedBlockFluidContainer fluidContainer;

    public WaterPumpBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 1);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new WaterPumpMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.deshTierEnergyCapacity, MachineConfig.deshTierMaxEnergyInOut));
        return this.energyContainer;
    }

    public WrappedBlockFluidContainer getFluidContainer() {
        if (this.fluidContainer != null) {
            return this.fluidContainer;
        }
        this.fluidContainer = new WrappedBlockFluidContainer((BlockEntity)this, (FluidContainer)new ExtractOnlyFluidContainer(i -> FluidConstants.fromMillibuckets((long)MachineConfig.deshTierFluidCapacity), 1, (tank, holder) -> holder.is(FluidTags.f_13131_)));
        return this.fluidContainer;
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        if (!this.canFunction()) {
            return;
        }
        if (this.canPump(pos, this.energyContainer)) {
            this.pump(level, this.energyContainer);
        }
    }

    private boolean canPump(BlockPos pos, WrappedBlockEnergyContainer energyStorage) {
        if (!this.level().m_6425_(pos.m_7495_()).m_192917_((Fluid)Fluids.f_76193_)) {
            return false;
        }
        if (energyStorage.internalExtract(MachineConfig.waterPumpEnergyPerTick, true) < MachineConfig.waterPumpEnergyPerTick) {
            return false;
        }
        return this.fluidContainer.getFirstFluid().getFluidAmount() < this.fluidContainer.getTankCapacity(0);
    }

    private void pump(ServerLevel level, WrappedBlockEnergyContainer energyStorage) {
        energyStorage.internalExtract(MachineConfig.waterPumpEnergyPerTick, false);
        this.fluidContainer.internalInsert(FluidHolder.ofMillibuckets((Fluid)Fluids.f_76193_, (long)FluidConstants.fromMillibuckets((long)MachineConfig.waterPumpFluidGenerationPerTick)), false);
        ModUtils.sendParticles(level, (SimpleParticleType)ModParticleTypes.OXYGEN_BUBBLE.get(), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() - 0.5, (double)this.m_58899_().m_123343_() + 0.5, 1, 0.0, 0.0, 0.0, 0.01);
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(0), filter);
        TransferUtils.pushFluidNearby(this, pos, this.getFluidContainer(), FluidConstants.fromMillibuckets((long)MachineConfig.waterPumpFluidGenerationPerTick), 0, sideConfig.get(1), filter);
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[0];
    }
}

