/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.handlers;

import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.api.systems.OxygenApi;
import earth.terrarium.adastra.api.systems.PlanetData;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PlanetHandler
extends SaveHandler {
    private final Map<BlockPos, PlanetData> planetData = new HashMap<BlockPos, PlanetData>();
    private final ServerLevel level;

    public PlanetHandler(ServerLevel level) {
        this.level = level;
    }

    public void loadData(CompoundTag tag) {
        int[] data = tag.m_128465_("");
        if (data.length % 3 != 0) {
            throw new RuntimeException("Invalid data length");
        }
        for (int i = 0; i < data.length; i += 3) {
            int firstPos = data[i];
            int secondPos = data[i + 1];
            this.planetData.put(BlockPos.m_122022_((long)((long)firstPos << 32 | (long)secondPos & 0xFFFFFFFFL)), PlanetData.unpack(data[i + 2]));
        }
    }

    public void saveData(CompoundTag tag) {
        boolean defaultOxygen = OxygenApi.API.hasOxygen((Level)this.level);
        short defaultTemperature = TemperatureApi.API.getTemperature((Level)this.level);
        float defaultGravity = GravityApi.API.getGravity((Level)this.level);
        IntArrayList dataArray = new IntArrayList(this.planetData.size() * 3);
        Set<Map.Entry<BlockPos, PlanetData>> entries = this.planetData.entrySet();
        for (Map.Entry<BlockPos, PlanetData> entry : entries) {
            PlanetData data = entry.getValue();
            if (data.oxygen() == defaultOxygen && data.temperature() == defaultTemperature && data.gravity() == defaultGravity) continue;
            long pos = entry.getKey().m_121878_();
            dataArray.add((int)(pos >> 32));
            dataArray.add((int)pos);
            dataArray.add(entry.getValue().pack());
        }
        tag.m_128385_("", dataArray.toIntArray());
    }

    public static PlanetHandler read(ServerLevel level) {
        return (PlanetHandler)PlanetHandler.read((DimensionDataStorage)level.m_8895_(), () -> new PlanetHandler(level), (String)"adastra_planet_data");
    }

    public static boolean hasOxygen(ServerLevel level, BlockPos pos) {
        PlanetData data = PlanetHandler.read((ServerLevel)level).planetData.get(pos);
        return data == null ? OxygenApi.API.hasOxygen((Level)level) : data.oxygen();
    }

    public static short getTemperature(ServerLevel level, BlockPos pos) {
        PlanetData data = PlanetHandler.read((ServerLevel)level).planetData.get(pos);
        return data == null ? TemperatureApi.API.getTemperature((Level)level) : data.temperature();
    }

    public static float getGravity(ServerLevel level, BlockPos pos) {
        PlanetData data = PlanetHandler.read((ServerLevel)level).planetData.get(pos);
        return data == null ? GravityApi.API.getGravity((Level)level) : data.gravity();
    }

    public static void setOxygen(ServerLevel level, BlockPos pos, boolean oxygen) {
        PlanetHandler data = PlanetHandler.read(level);
        data.planetData.computeIfAbsent(pos, p -> new PlanetData(oxygen, PlanetHandler.getTemperature(level, p), PlanetHandler.getGravity(level, p))).setOxygen(oxygen);
    }

    public static void setTemperature(ServerLevel level, BlockPos pos, short temperature) {
        PlanetHandler data = PlanetHandler.read(level);
        data.planetData.computeIfAbsent(pos, p -> new PlanetData(PlanetHandler.hasOxygen(level, p), temperature, PlanetHandler.getGravity(level, p))).setTemperature(temperature);
    }

    public static void setGravity(ServerLevel level, BlockPos pos, float gravity) {
        PlanetHandler data = PlanetHandler.read(level);
        data.planetData.computeIfAbsent(pos, p -> new PlanetData(PlanetHandler.hasOxygen(level, p), PlanetHandler.getTemperature(level, p), gravity)).setGravity(gravity);
    }

    public static void setOxygen(ServerLevel level, Collection<BlockPos> positions, boolean oxygen) {
        PlanetHandler data = PlanetHandler.read(level);
        for (BlockPos pos : positions) {
            data.planetData.computeIfAbsent(pos, p -> new PlanetData(oxygen, PlanetHandler.getTemperature(level, p), PlanetHandler.getGravity(level, p))).setOxygen(oxygen);
        }
    }

    public static void setTemperature(ServerLevel level, Collection<BlockPos> positions, short temperature) {
        PlanetHandler data = PlanetHandler.read(level);
        for (BlockPos pos : positions) {
            data.planetData.computeIfAbsent(pos, p -> new PlanetData(PlanetHandler.hasOxygen(level, p), temperature, PlanetHandler.getGravity(level, p))).setTemperature(temperature);
        }
    }

    public static void setGravity(ServerLevel level, Collection<BlockPos> positions, float gravity) {
        PlanetHandler data = PlanetHandler.read(level);
        for (BlockPos pos : positions) {
            data.planetData.computeIfAbsent(pos, p -> new PlanetData(PlanetHandler.hasOxygen(level, p), PlanetHandler.getTemperature(level, p), gravity)).setGravity(gravity);
        }
    }

    public boolean m_77764_() {
        return true;
    }
}

