/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.systems;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.api.systems.GravityApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.PlanetHandler;
import earth.terrarium.adastra.mixins.common.LivingEntityAccessor;
import java.util.Collection;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GravityApiImpl
implements GravityApi {
    @Override
    public float getGravity(Level level) {
        return this.getGravity((ResourceKey<Level>)level.m_46472_());
    }

    @Override
    public float getGravity(ResourceKey<Level> level) {
        return ((Float)Optionull.m_269278_((Object)PlanetApi.API.getPlanet(level), Planet::gravity, (Object)Float.valueOf(9.807f))).floatValue() / 9.807f;
    }

    @Override
    public float getGravity(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return this.getGravity(level);
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return PlanetHandler.getGravity(serverLevel, pos);
    }

    @Override
    public float getGravity(Entity entity) {
        if (AdAstraConfig.disableGravity) {
            return 1.0f;
        }
        float gravity = this.getGravity(entity.m_9236_(), BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20188_(), (double)entity.m_20189_()));
        return AdAstraEvents.EntityGravityEvent.fire(entity, gravity);
    }

    @Override
    public void setGravity(Level level, BlockPos pos, float gravity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PlanetHandler.setGravity(serverLevel, pos, gravity);
    }

    @Override
    public void setGravity(Level level, Collection<BlockPos> positions, float gravity) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        PlanetHandler.setGravity(serverLevel, positions, gravity);
    }

    @Override
    public void removeGravity(Level level, BlockPos pos) {
        this.setGravity(level, pos, this.getGravity(level));
    }

    @Override
    public void removeGravity(Level level, Collection<BlockPos> positions) {
        this.setGravity(level, positions, this.getGravity(level));
    }

    @Override
    public void entityTick(Level level, LivingEntity entity, Vec3 travelVector, BlockPos movementAffectingPos) {
        if (AdAstraConfig.disableGravity) {
            return;
        }
        if (!entity.m_6109_()) {
            return;
        }
        boolean touchingSomething = false;
        for (Direction direction : Direction.values()) {
            BlockPos pos = movementAffectingPos.m_121945_(direction);
            if (level.m_8055_(pos).m_60795_()) continue;
            touchingSomething = true;
            break;
        }
        float ySpeed = 0.0f;
        if ((touchingSomething || level.m_46467_() % 10L == 0L) && entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_6144_()) {
                ySpeed = -0.01f;
            } else if (((LivingEntityAccessor)player).isJumping()) {
                ySpeed = 0.01f;
            }
        }
        if (!touchingSomething) {
            travelVector = travelVector.m_82490_((double)0.12f);
        }
        float friction = level.m_8055_(movementAffectingPos).m_60734_().m_49958_();
        float speed = touchingSomething ? (entity.m_20096_() ? friction * 0.91f : 0.91f) : (entity.m_20096_() ? friction * 0.999f : 0.999f);
        Vec3 movementVector = entity.m_21074_(travelVector, friction);
        double downSpeed = movementVector.f_82480_;
        if (entity.m_9236_().m_5776_() && !entity.m_9236_().m_46805_(movementAffectingPos)) {
            downSpeed = entity.m_20186_() > (double)entity.m_9236_().m_141937_() ? -0.1 : 0.0;
        }
        downSpeed += (double)ySpeed;
        if (entity.m_147223_()) {
            entity.m_20334_(movementVector.f_82479_, downSpeed, movementVector.f_82481_);
        } else {
            entity.m_20334_(movementVector.f_82479_ * (double)speed, downSpeed * 0.98, movementVector.f_82481_ * (double)speed);
        }
        entity.m_267651_(this instanceof FlyingAnimal);
    }
}

