/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.mixins.client;

import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.client.config.AdAstraConfigClient;
import earth.terrarium.adastra.client.utils.ClientData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundManager.class})
public abstract class SoundManagerMixin {
    @Shadow
    @Final
    private SoundEngine f_120349_;

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    private void adastra$play(SoundInstance sound, CallbackInfo ci) {
        if (this.adastra$play(sound, 0)) {
            ci.cancel();
        }
    }

    @Inject(method={"playDelayed"}, at={@At(value="HEAD")}, cancellable=true)
    private void adastra$playDelayed(SoundInstance sound, int delay, CallbackInfo ci) {
        if (this.adastra$play(sound, delay)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean adastra$play(SoundInstance sound, int delay) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return false;
        }
        if (!AdAstraConfigClient.spaceMuffler) {
            return false;
        }
        SoundSource source = sound.m_8070_();
        if (source == SoundSource.MASTER) {
            return false;
        }
        if (!PlanetApi.API.isSpace((Level)level)) {
            return false;
        }
        if (sound instanceof TickableSoundInstance) {
            return false;
        }
        if (source != SoundSource.MUSIC && ClientData.getLocalData() != null && ClientData.getLocalData().oxygen()) {
            return false;
        }
        Minecraft.m_91087_().execute(() -> {
            float volume = source == SoundSource.MUSIC || source == SoundSource.RECORDS ? 1.0f : 0.1f;
            SimpleSoundInstance newSound = new SimpleSoundInstance(sound.m_7904_(), source, volume, 0.1f, level.f_46441_, sound.m_7775_(), delay, sound.m_7438_(), sound.m_7772_(), sound.m_7780_(), sound.m_7778_(), sound.m_7796_());
            if (delay == 0) {
                this.f_120349_.m_120312_((SoundInstance)newSound);
            } else {
                this.f_120349_.m_120276_((SoundInstance)newSound, delay);
            }
        });
        return true;
    }
}

