/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BannerPattern;
import vazkii.botania.api.mana.spark.SparkUpgradeType;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ItemWithBannerPattern;
import vazkii.botania.common.lib.BotaniaTags;

public class SparkAugmentItem
extends Item
implements ItemWithBannerPattern {
    public final SparkUpgradeType type;

    public SparkAugmentItem(Item.Properties builder, SparkUpgradeType type) {
        super(builder);
        this.type = type;
    }

    @Override
    public TagKey<BannerPattern> getBannerPattern() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case SparkUpgradeType.DOMINANT -> BotaniaTags.BannerPatterns.PATTERN_ITEM_SPARK_DOMINANT;
            case SparkUpgradeType.RECESSIVE -> BotaniaTags.BannerPatterns.PATTERN_ITEM_SPARK_RECESSIVE;
            case SparkUpgradeType.DISPERSIVE -> BotaniaTags.BannerPatterns.PATTERN_ITEM_SPARK_DISPERSIVE;
            case SparkUpgradeType.ISOLATED -> BotaniaTags.BannerPatterns.PATTERN_ITEM_SPARK_ISOLATED;
            case SparkUpgradeType.NONE -> throw new IllegalArgumentException("SparkAugmentItem with none type");
        };
    }

    public static ItemStack getByType(SparkUpgradeType type) {
        return switch (type) {
            case SparkUpgradeType.DOMINANT -> new ItemStack((ItemLike)BotaniaItems.sparkUpgradeDominant);
            case SparkUpgradeType.RECESSIVE -> new ItemStack((ItemLike)BotaniaItems.sparkUpgradeRecessive);
            case SparkUpgradeType.DISPERSIVE -> new ItemStack((ItemLike)BotaniaItems.sparkUpgradeDispersive);
            case SparkUpgradeType.ISOLATED -> new ItemStack((ItemLike)BotaniaItems.sparkUpgradeIsolated);
            default -> ItemStack.f_41583_;
        };
    }
}

