/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.configdata.LooniumMobAttributeModifier;
import vazkii.botania.api.configdata.LooniumMobEffectToApply;
import vazkii.botania.api.configdata.LooniumMobSpawnData;
import vazkii.botania.api.configdata.LooniumStructureConfiguration;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.BotaniaLootTables;

public class LooniumStructureConfigurationProvider
implements DataProvider {
    public static final String LOONIUM_MODIFIER_DAMAGE = "Loonium Modifier Damage";
    public static final String LOONIUM_MODIFIER_HEALTH = "Loonium Modifier Health";
    private final PackOutput.PathProvider pathProvider;

    public LooniumStructureConfigurationProvider(PackOutput packOutput) {
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loonium_config");
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        HashMap<ResourceLocation, LooniumStructureConfiguration> configs = new HashMap<ResourceLocation, LooniumStructureConfiguration>();
        this.addConfigs(configs);
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>(configs.size());
        for (Map.Entry e : configs.entrySet()) {
            Path path = this.pathProvider.m_245731_((ResourceLocation)e.getKey());
            LooniumStructureConfiguration config = (LooniumStructureConfiguration)e.getValue();
            JsonElement jsonTree = (JsonElement)LooniumStructureConfiguration.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(false, arg_0 -> ((Logger)BotaniaAPI.LOGGER).error(arg_0));
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)jsonTree, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addConfigs(Map<ResourceLocation, LooniumStructureConfiguration> configs) {
        ResourceLocation defaultConfigId = LooniumStructureConfiguration.DEFAULT_CONFIG_ID;
        configs.put(defaultConfigId, LooniumStructureConfigurationProvider.getDefaultConfig());
        configs.put(BuiltinStructures.f_226492_.m_135782_(), LooniumStructureConfigurationProvider.getConfigAncientCity(defaultConfigId));
        configs.put(BuiltinStructures.f_209863_.m_135782_(), LooniumStructureConfigurationProvider.getConfigBastionRemnant(defaultConfigId));
        configs.put(BuiltinStructures.f_209850_.m_135782_(), LooniumStructureConfigurationProvider.getConfigDesertPyramid(defaultConfigId));
        configs.put(BuiltinStructures.f_209861_.m_135782_(), LooniumStructureConfigurationProvider.getConfigEndCity(defaultConfigId));
        configs.put(BuiltinStructures.f_209859_.m_135782_(), LooniumStructureConfigurationProvider.getConfigFortress(defaultConfigId));
        configs.put(BuiltinStructures.f_209849_.m_135782_(), LooniumStructureConfigurationProvider.getConfigJungleTemple(defaultConfigId));
        configs.put(BuiltinStructures.f_209856_.m_135782_(), LooniumStructureConfigurationProvider.getConfigOceanMonument(defaultConfigId));
        ResourceLocation oceanRuinId = ResourceLocationHelper.prefix("ocean_ruins");
        configs.put(oceanRuinId, LooniumStructureConfiguration.forParent(defaultConfigId).boundingBoxType(StructureSpawnOverride.BoundingBoxType.STRUCTURE).build());
        configs.put(BuiltinStructures.f_209857_.m_135782_(), LooniumStructureConfigurationProvider.getConfigOceanRuinCold(oceanRuinId));
        configs.put(BuiltinStructures.f_209858_.m_135782_(), LooniumStructureConfigurationProvider.getConfigOceanRuinWarm(oceanRuinId));
        configs.put(BuiltinStructures.f_209845_.m_135782_(), LooniumStructureConfigurationProvider.getConfigPillagerOutpost(defaultConfigId));
        configs.put(BuiltinStructures.f_209870_.m_135782_(), LooniumStructureConfigurationProvider.getConfigRuinedPortalDesert(defaultConfigId));
        configs.put(BuiltinStructures.f_209840_.m_135782_(), LooniumStructureConfigurationProvider.getConfigRuinedPortalJungle(defaultConfigId));
        configs.put(BuiltinStructures.f_209842_.m_135782_(), LooniumStructureConfigurationProvider.getConfigRuinedPortalMountain(defaultConfigId));
        configs.put(BuiltinStructures.f_209844_.m_135782_(), LooniumStructureConfigurationProvider.getConfigRuinedPortalNether(defaultConfigId));
        configs.put(BuiltinStructures.f_209843_.m_135782_(), LooniumStructureConfigurationProvider.getConfigRuinedPortalOcean(defaultConfigId));
        configs.put(BuiltinStructures.f_209869_.m_135782_(), LooniumStructureConfigurationProvider.getConfigRuinedPortalStandard(defaultConfigId));
        configs.put(BuiltinStructures.f_209841_.m_135782_(), LooniumStructureConfigurationProvider.getConfigRuinedPortalSwamp(defaultConfigId));
        configs.put(BuiltinStructures.f_209852_.m_135782_(), LooniumStructureConfigurationProvider.getConfigShipwreck(defaultConfigId));
        configs.put(BuiltinStructures.f_209853_.m_135782_(), LooniumStructureConfiguration.forParent(BuiltinStructures.f_209852_.m_135782_()).build());
        configs.put(BuiltinStructures.f_209855_.m_135782_(), LooniumStructureConfigurationProvider.getConfigStronghold(defaultConfigId));
        configs.put(BuiltinStructures.f_276588_.m_135782_(), LooniumStructureConfigurationProvider.getConfigTrailRuins(defaultConfigId));
        ResourceLocation villageId = ResourceLocationHelper.prefix("village");
        configs.put(villageId, LooniumStructureConfiguration.forParent(defaultConfigId).boundingBoxType(StructureSpawnOverride.BoundingBoxType.STRUCTURE).build());
        configs.put(BuiltinStructures.f_209865_.m_135782_(), LooniumStructureConfigurationProvider.getConfigVillageDesert(villageId));
        configs.put(BuiltinStructures.f_209864_.m_135782_(), LooniumStructureConfigurationProvider.getConfigVillagePlains(villageId));
        configs.put(BuiltinStructures.f_209866_.m_135782_(), LooniumStructureConfigurationProvider.getConfigVillageSavanna(villageId));
        configs.put(BuiltinStructures.f_209867_.m_135782_(), LooniumStructureConfigurationProvider.getConfigVillageSnowy(villageId));
        configs.put(BuiltinStructures.f_209868_.m_135782_(), LooniumStructureConfigurationProvider.getConfigVillageTaiga(villageId));
        configs.put(BuiltinStructures.f_209848_.m_135782_(), LooniumStructureConfigurationProvider.getConfigWoodlandMansion(defaultConfigId));
    }

    public static LooniumStructureConfiguration getDefaultConfig() {
        return LooniumStructureConfiguration.builder().manaCost(35000).maxNearbyMobs(10).boundingBoxType(StructureSpawnOverride.BoundingBoxType.PIECE).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 529).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).attributeModifiers(new LooniumMobAttributeModifier(LOONIUM_MODIFIER_HEALTH, Attributes.f_22276_, 2.0, AttributeModifier.Operation.MULTIPLY_BASE), new LooniumMobAttributeModifier(LOONIUM_MODIFIER_DAMAGE, Attributes.f_22281_, 1.5, AttributeModifier.Operation.MULTIPLY_BASE)).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, true)).build();
    }

    public static LooniumStructureConfiguration getConfigAncientCity(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 40).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 80).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 410).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 60).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 440).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_ANCIENT_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 100).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 200).build()).build();
    }

    public static LooniumStructureConfiguration getConfigBastionRemnant(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getPiglinSpawnData(450, BotaniaLootTables.LOONIUM_PIGLIN_BASTION_REMNANT, false, false), LooniumMobSpawnData.entityWeight(EntityType.f_20512_, 50).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE_GOLD).attributeModifiers(new LooniumMobAttributeModifier(LOONIUM_MODIFIER_HEALTH, Attributes.f_22276_, 1.5, AttributeModifier.Operation.MULTIPLY_BASE), new LooniumMobAttributeModifier(LOONIUM_MODIFIER_DAMAGE, Attributes.f_22281_, 1.5, AttributeModifier.Operation.MULTIPLY_BASE)).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20456_, 300).spawnAsAdult().build()).build();
    }

    public static LooniumStructureConfiguration getConfigDesertPyramid(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 50).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_DESERT_PYRAMID).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 40).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 360).build()).build();
    }

    public static LooniumStructureConfiguration getConfigEndCity(ResourceLocation parentId) {
        LooniumMobEffectToApply[] creeperEffects = new LooniumMobEffectToApply[]{LooniumMobEffectToApply.effect(MobEffects.f_19607_).duration(100).build(), LooniumMobEffectToApply.effect(MobEffects.f_19605_).duration(100).build(), LooniumMobEffectToApply.effect(MobEffects.f_19591_).duration(400).build()};
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20521_, 100).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(true, true)).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 300).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, creeperEffects), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, creeperEffects), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 300).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_END_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 300).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_END_CITY).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 300).build()).effectsToApply(LooniumMobEffectToApply.effect(MobEffects.f_19607_).build(), LooniumMobEffectToApply.effect(MobEffects.f_19605_).build(), LooniumMobEffectToApply.effect(MobEffects.f_19591_).build()).build();
    }

    public static LooniumStructureConfiguration getConfigFortress(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(99, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20551_, 300).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20497_, 450).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 50).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_FORTRESS).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20531_, 400).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_FORTRESS).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build()).build();
    }

    public static LooniumStructureConfiguration getConfigJungleTemple(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_JUNGLE_TEMPLE).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 300).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 300).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanMonument(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20455_, 200).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 360).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_MONUMENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanRuinCold(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 540).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 60).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 40).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 360).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigOceanRuinWarm(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 540).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 60).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 400).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigPillagerOutpost(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).boundingBoxType(StructureSpawnOverride.BoundingBoxType.STRUCTURE).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20513_, 900).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20493_, 175).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20568_, 25).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 200).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_OUTPOST).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 200).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_OUTPOST).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 200).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalDesert(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20500_, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.f_20531_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 50).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 450).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 360).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalJungle(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20500_, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.f_20531_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 250).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 50).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalMountain(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20500_, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.f_20531_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 529).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 59).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 529).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20523_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalNether(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20500_, 125).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(500, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, false), LooniumMobSpawnData.entityWeight(EntityType.f_20531_, 450).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 200).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 10).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 90).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalOcean(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20500_, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, true, true), LooniumMobSpawnData.entityWeight(EntityType.f_20531_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 400).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalStandard(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20500_, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.f_20531_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 59).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 106).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 423).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 59).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 529).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigRuinedPortalSwamp(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20500_, 25).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(false, false)).build(), LooniumStructureConfigurationProvider.getPiglinSpawnData(50, BotaniaLootTables.LOONIUM_PIGLIN_PORTAL, false, true), LooniumMobSpawnData.entityWeight(EntityType.f_20531_, 50).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 30).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 360).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 500).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_PORTAL).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 50).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 250).build()).build();
    }

    public static LooniumStructureConfiguration getConfigShipwreck(ResourceLocation parentId) {
        LooniumMobEffectToApply[] standardEffectsInWater = LooniumStructureConfigurationProvider.getStandardEffects(true, true);
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(true)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 540).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 60).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 40).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 360).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_SHIPWRECK).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 30).effectsToApply(standardEffectsInWater).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 270).effectsToApply(standardEffectsInWater).build()).build();
    }

    public static LooniumStructureConfiguration getConfigStronghold(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 80).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(149, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 40).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 40).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 410).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 60).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 440).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_STRONGHOLD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 100).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20523_, 100).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 400).build()).build();
    }

    public static LooniumStructureConfiguration getConfigTrailRuins(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 59).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 106).equipmentTable(BotaniaLootTables.LOONIUM_DROWNED_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 423).equipmentTable(BotaniaLootTables.LOONIUM_ZOMBIE_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 59).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 529).equipmentTable(BotaniaLootTables.LOONIUM_SKELETON_TRAIL_RUINS).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageDesert(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20530_, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillagePlains(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20530_, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageSavanna(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 30).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20458_, 30).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20530_, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageSnowy(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20530_, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 529).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigVillageTaiga(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(195, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20562_, 59).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_TRIDENT).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_SWORD).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20530_, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BY_PROFESSION).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20481_, 106).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 423).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_BOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 59).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 529).build()).build();
    }

    public static LooniumStructureConfiguration getConfigWoodlandMansion(ResourceLocation parentId) {
        return LooniumStructureConfiguration.forParent(parentId).spawnedMobs(LooniumMobSpawnData.entityWeight(EntityType.f_20566_, 40).build(), LooniumStructureConfigurationProvider.getCreeperSpawnData(199, false, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumStructureConfigurationProvider.getCreeperSpawnData(1, true, LooniumStructureConfigurationProvider.getCreeperEffects(false)), LooniumMobSpawnData.entityWeight(EntityType.f_20493_, 600).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_AXE).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20513_, 200).equipmentTable(BotaniaLootTables.LOONIUM_WEAPON_CROSSBOW).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20568_, 100).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 150).equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20501_, 50).spawnAsBaby().equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20524_, 200).equipmentTable(BotaniaLootTables.LOONIUM_ARMOR_MANSION).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20554_, 30).build(), LooniumMobSpawnData.entityWeight(EntityType.f_20479_, 270).build()).build();
    }

    public static LooniumMobEffectToApply[] getStandardEffects(boolean withWaterBreathing, boolean withFireResistance) {
        LooniumMobEffectToApply[] looniumMobEffectToApplyArray;
        if (withFireResistance) {
            if (withWaterBreathing) {
                LooniumMobEffectToApply[] looniumMobEffectToApplyArray2 = new LooniumMobEffectToApply[3];
                looniumMobEffectToApplyArray2[0] = LooniumMobEffectToApply.effect(MobEffects.f_19607_).build();
                looniumMobEffectToApplyArray2[1] = LooniumMobEffectToApply.effect(MobEffects.f_19605_).build();
                looniumMobEffectToApplyArray = looniumMobEffectToApplyArray2;
                looniumMobEffectToApplyArray2[2] = LooniumMobEffectToApply.effect(MobEffects.f_19608_).build();
            } else {
                LooniumMobEffectToApply[] looniumMobEffectToApplyArray3 = new LooniumMobEffectToApply[2];
                looniumMobEffectToApplyArray3[0] = LooniumMobEffectToApply.effect(MobEffects.f_19607_).build();
                looniumMobEffectToApplyArray = looniumMobEffectToApplyArray3;
                looniumMobEffectToApplyArray3[1] = LooniumMobEffectToApply.effect(MobEffects.f_19605_).build();
            }
        } else if (withWaterBreathing) {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray4 = new LooniumMobEffectToApply[2];
            looniumMobEffectToApplyArray4[0] = LooniumMobEffectToApply.effect(MobEffects.f_19605_).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray4;
            looniumMobEffectToApplyArray4[1] = LooniumMobEffectToApply.effect(MobEffects.f_19608_).build();
        } else {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray5 = new LooniumMobEffectToApply[1];
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray5;
            looniumMobEffectToApplyArray5[0] = LooniumMobEffectToApply.effect(MobEffects.f_19605_).build();
        }
        return looniumMobEffectToApplyArray;
    }

    public static LooniumMobEffectToApply[] getCreeperEffects(boolean withWaterBreathing) {
        LooniumMobEffectToApply[] looniumMobEffectToApplyArray;
        if (withWaterBreathing) {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray2 = new LooniumMobEffectToApply[3];
            looniumMobEffectToApplyArray2[0] = LooniumMobEffectToApply.effect(MobEffects.f_19607_).duration(100).build();
            looniumMobEffectToApplyArray2[1] = LooniumMobEffectToApply.effect(MobEffects.f_19605_).duration(100).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray2;
            looniumMobEffectToApplyArray2[2] = LooniumMobEffectToApply.effect(MobEffects.f_19608_).build();
        } else {
            LooniumMobEffectToApply[] looniumMobEffectToApplyArray3 = new LooniumMobEffectToApply[2];
            looniumMobEffectToApplyArray3[0] = LooniumMobEffectToApply.effect(MobEffects.f_19607_).duration(100).build();
            looniumMobEffectToApplyArray = looniumMobEffectToApplyArray3;
            looniumMobEffectToApplyArray3[1] = LooniumMobEffectToApply.effect(MobEffects.f_19605_).duration(100).build();
        }
        return looniumMobEffectToApplyArray;
    }

    public static LooniumMobSpawnData getCreeperSpawnData(int weight, boolean charged, LooniumMobEffectToApply ... creeperEffects) {
        CompoundTag chargedCreeperNbt;
        if (charged) {
            chargedCreeperNbt = new CompoundTag();
            chargedCreeperNbt.m_128379_("powered", true);
        } else {
            chargedCreeperNbt = null;
        }
        return LooniumMobSpawnData.entityWeight(EntityType.f_20558_, weight).nbt(chargedCreeperNbt).effectsToApply(creeperEffects).build();
    }

    public static LooniumMobSpawnData getPiglinSpawnData(int weight, ResourceLocation equipmentTable, boolean needWaterBreathing, boolean zombificationImmune) {
        CompoundTag piglinNbt = new CompoundTag();
        if (zombificationImmune) {
            piglinNbt.m_128379_("IsImmuneToZombification", true);
        }
        Brain piglinBrain = Brain.m_21923_(List.of(MemoryModuleType.f_26335_, MemoryModuleType.f_26339_, MemoryModuleType.f_26355_), List.of()).m_22073_(new Dynamic((DynamicOps)NbtOps.f_128958_));
        piglinBrain.m_21879_(MemoryModuleType.f_26335_, (Object)true);
        piglinBrain.m_21879_(MemoryModuleType.f_26339_, (Object)true);
        piglinBrain.m_21879_(MemoryModuleType.f_26355_, (Object)true);
        DataResult dataResult = piglinBrain.m_21914_((DynamicOps)NbtOps.f_128958_);
        dataResult.resultOrPartial(arg_0 -> ((Logger)BotaniaAPI.LOGGER).error(arg_0)).ifPresent(tag -> piglinNbt.m_128365_("Brain", tag));
        return LooniumMobSpawnData.entityWeight(EntityType.f_20511_, weight).spawnAsAdult().nbt(piglinNbt).equipmentTable(equipmentTable).effectsToApply(LooniumStructureConfigurationProvider.getStandardEffects(needWaterBreathing, true)).build();
    }

    @NotNull
    public String m_6055_() {
        return "Loonium structure configuration";
    }
}

