/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.Deserializers;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class LooniumStructureLootProvider
implements DataProvider {
    public static final EnumSet<VillageLoot> PLAINS_VILLAGE_LOOT = EnumSet.of(VillageLoot.CARTOGRAPHER, VillageLoot.FISHER, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> DESERT_VILLAGE_LOOT = EnumSet.of(VillageLoot.TEMPLE, VillageLoot.TOOLSMITH, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> SAVANNA_VILLAGE_LOOT = EnumSet.of(VillageLoot.BUTCHER, VillageLoot.CARTOGRAPHER, VillageLoot.MASON, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> SNOWY_VILLAGE_LOOT = EnumSet.of(VillageLoot.ARMORER, VillageLoot.CARTOGRAPHER, VillageLoot.SHEPHERD, VillageLoot.TANNERY, VillageLoot.WEAPONSMITH);
    public static final EnumSet<VillageLoot> TAIGA_VILLAGE_LOOT = EnumSet.of(VillageLoot.CARTOGRAPHER, VillageLoot.FLETCHER, VillageLoot.TANNERY, VillageLoot.TOOLSMITH, VillageLoot.WEAPONSMITH);
    private final PackOutput.PathProvider pathProvider;

    public LooniumStructureLootProvider(PackOutput packOutput) {
        this.pathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "loot_tables/loonium");
    }

    public static ResourceLocation getStructureId(ResourceKey<Structure> structureKey) {
        return LooniumStructureLootProvider.getStructureId(structureKey.m_135782_());
    }

    public static ResourceLocation getStructureId(ResourceLocation structureId) {
        return ResourceLocationHelper.prefix("%s/%s".formatted(structureId.m_135827_(), structureId.m_135815_()));
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        HashMap<ResourceLocation, LootTable.Builder> tables = new HashMap<ResourceLocation, LootTable.Builder>();
        this.addLootTables(tables);
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>(tables.size());
        for (Map.Entry e : tables.entrySet()) {
            Path path = this.pathProvider.m_245731_((ResourceLocation)e.getKey());
            LootTable.Builder builder = (LootTable.Builder)e.getValue();
            LootTable lootTable = builder.m_79165_(LootContextParamSets.f_81420_).m_79167_();
            JsonElement jsonTree = Deserializers.m_78800_().create().toJsonTree((Object)lootTable);
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)jsonTree, (Path)path));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void addLootTables(Map<ResourceLocation, LootTable.Builder> tables) {
        tables.put(ResourceLocationHelper.prefix("default"), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78742_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_226492_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_230876_).m_79707_(9)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_230877_).m_79707_(1))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209863_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78699_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78700_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78697_).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78698_).m_79707_(7))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209862_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78692_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209850_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78764_).m_79707_(37)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_276661_).m_79707_(2)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_276662_))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209861_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78741_).m_79707_(49)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42741_))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209859_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78760_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209849_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78686_).m_79707_(9)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78687_))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209846_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78759_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209847_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78759_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209856_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20563_.m_20677_()).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_41903_))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209857_), LooniumStructureLootProvider.buildOceanRuinLootTable(BuiltInLootTables.f_276614_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209858_), LooniumStructureLootProvider.buildOceanRuinLootTable(BuiltInLootTables.f_276611_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209845_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78696_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209870_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78701_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209840_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78701_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209842_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78701_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209844_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78701_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209843_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78701_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209869_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78701_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209841_), LooniumStructureLootProvider.buildDelegateLootTable(BuiltInLootTables.f_78701_));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209852_), LooniumStructureLootProvider.buildShipwreckLootTable());
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209853_), LooniumStructureLootProvider.buildShipwreckLootTable());
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209855_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78763_).m_79707_(4)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78762_).m_79707_(6)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78761_).m_79707_(3))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_276588_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_279573_).m_79707_(9)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_279604_))));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209864_), LooniumStructureLootProvider.buildVillageLootTable(BuiltInLootTables.f_78755_, PLAINS_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209865_), LooniumStructureLootProvider.buildVillageLootTable(BuiltInLootTables.f_78754_, DESERT_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209866_), LooniumStructureLootProvider.buildVillageLootTable(BuiltInLootTables.f_78758_, SAVANNA_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209867_), LooniumStructureLootProvider.buildVillageLootTable(BuiltInLootTables.f_78757_, SNOWY_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209868_), LooniumStructureLootProvider.buildVillageLootTable(BuiltInLootTables.f_78756_, TAIGA_VILLAGE_LOOT));
        tables.put(LooniumStructureLootProvider.getStructureId((ResourceKey<Structure>)BuiltinStructures.f_209848_), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78689_).m_79707_(99)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42747_).m_79707_(1))));
    }

    public static LootTable.Builder buildVillageLootTable(ResourceLocation house, Set<VillageLoot> villageLootSet) {
        LootPool.Builder lootPool = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)house).m_79707_(3));
        for (VillageLoot loot : villageLootSet) {
            lootPool.m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)loot.lootTable));
        }
        return LootTable.m_79147_().m_79161_(lootPool);
    }

    @NotNull
    public static LootTable.Builder buildShipwreckLootTable() {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78693_)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78694_)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78695_)));
    }

    @NotNull
    public static LootTable.Builder buildDelegateLootTable(ResourceLocation reference) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)reference)));
    }

    @NotNull
    public static LootTable.Builder buildOceanRuinLootTable(ResourceLocation archaeology) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78691_)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)BuiltInLootTables.f_78690_).m_79707_(8)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)archaeology)));
    }

    @NotNull
    public String m_6055_() {
        return "Structure-specific loot tables for the Loonium";
    }

    public static enum VillageLoot {
        WEAPONSMITH(BuiltInLootTables.f_78743_),
        TOOLSMITH(BuiltInLootTables.f_78744_),
        ARMORER(BuiltInLootTables.f_78745_),
        CARTOGRAPHER(BuiltInLootTables.f_78746_),
        MASON(BuiltInLootTables.f_78747_),
        SHEPHERD(BuiltInLootTables.f_78748_),
        BUTCHER(BuiltInLootTables.f_78749_),
        FLETCHER(BuiltInLootTables.f_78750_),
        FISHER(BuiltInLootTables.f_78751_),
        TANNERY(BuiltInLootTables.f_78752_),
        TEMPLE(BuiltInLootTables.f_78753_);

        public final ResourceLocation lootTable;

        private VillageLoot(ResourceLocation lootTable) {
            this.lootTable = lootTable;
        }
    }
}

