/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import mrtjp.projectred.api.IScrewdriver;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.tile.IBlockEventBlockEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public interface IOrientableBlockEntity
extends IBlockEventBlockEntity {
    default public int getRotation() {
        return (Integer)this.getBlockLevel().m_8055_(this.getBlockPosition()).m_61143_((Property)ProjectRedBlock.ROTATION);
    }

    default public void setRotation(int r) {
        BlockState state = (BlockState)this.getBlockLevel().m_8055_(this.getBlockPosition()).m_61124_((Property)ProjectRedBlock.ROTATION, (Comparable)Integer.valueOf(r));
        this.getBlockLevel().m_46597_(this.getBlockPosition(), state);
    }

    default public int getSide() {
        return (Integer)this.getBlockLevel().m_8055_(this.getBlockPosition()).m_61143_((Property)ProjectRedBlock.SIDE);
    }

    default public void setSide(int s) {
        BlockState state = (BlockState)this.getBlockLevel().m_8055_(this.getBlockPosition()).m_61124_((Property)ProjectRedBlock.SIDE, (Comparable)Integer.valueOf(s));
        this.getBlockLevel().m_46597_(this.getBlockPosition(), state);
    }

    @Override
    default public InteractionResult onBlockActivated(Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = player.m_21120_(hand);
        Item item = held.m_41720_();
        if (item instanceof IScrewdriver) {
            IScrewdriver screwdriver = (IScrewdriver)item;
            if (screwdriver.canUse(player, held)) {
                if (!this.getBlockLevel().f_46443_) {
                    if ((player.m_6144_() || !this.canOrient()) && this.canRotate()) {
                        this.rotateBlock();
                    } else if (this.canOrient()) {
                        this.orientBlock();
                    }
                    screwdriver.damageScrewdriver(player, held);
                }
                return InteractionResult.m_19078_((boolean)this.getBlockLevel().f_46443_);
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    default public boolean canRotate() {
        return this.getBlockLevel().m_8055_(this.getBlockPosition()).m_61138_((Property)ProjectRedBlock.ROTATION);
    }

    default public boolean canOrient() {
        return this.getBlockLevel().m_8055_(this.getBlockPosition()).m_61138_((Property)ProjectRedBlock.SIDE);
    }

    default public void rotateBlock() {
        this.setRotation((this.getRotation() + 1) % 4);
        this.onOrientationChange();
    }

    default public void orientBlock() {
        this.setSide((this.getSide() + 1) % 6);
        this.onOrientationChange();
    }

    public void onOrientationChange();
}

