/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.data.MCDataByteBuf;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import java.util.Objects;
import mrtjp.projectred.core.tile.IBlockEventBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ProjectRedBlockEntity
extends BlockEntity
implements IBlockEventBlockEntity {
    public ProjectRedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveToNBT(tag);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadFromNBT(tag);
    }

    public final CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        MCDataByteBuf out = new MCDataByteBuf();
        this.writeDesc((MCDataOutput)out);
        out.writeToNBT(tag, "descpkt");
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        MCDataByteBuf in = MCDataByteBuf.readFromNBT((CompoundTag)tag, (String)"descpkt");
        this.readDesc((MCDataInput)in);
    }

    protected void pushBlockState() {
        if (!this.getBlockLevel().f_46443_) {
            BlockState currentState = this.getBlockLevel().m_8055_(this.getBlockPosition());
            BlockState newState = this.storeBlockState(currentState);
            this.getBlockLevel().m_46597_(this.getBlockPosition(), newState);
        }
    }

    @Override
    public Level getBlockLevel() {
        return Objects.requireNonNull(this.m_58904_());
    }

    @Override
    public BlockPos getBlockPosition() {
        return this.m_58899_();
    }

    public static void dropItem(ItemStack stack, Level world, Vector3 pos) {
        ItemEntity item = new ItemEntity(world, pos.x, pos.y, pos.z, stack);
        item.m_20334_(world.f_46441_.m_188583_() * 0.05, world.f_46441_.m_188583_() * 0.05 + 0.2, world.f_46441_.m_188583_() * 0.05);
        item.m_32010_(10);
        world.m_7967_((Entity)item);
    }

    public static void dropInventory(Container inventory, Level world, Vector3 pos) {
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack.m_41619_()) continue;
            ProjectRedBlockEntity.dropItem(stack, world, pos);
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    public static void ejectItem(ItemStack stack, Level world, BlockPos pos, int dir, double velocity) {
        Vector3 dirVec = switch (dir) {
            case 0 -> new Vector3(0.0, -1.0, 0.0);
            case 1 -> new Vector3(0.0, 1.0, 0.0);
            case 2 -> new Vector3(0.0, 0.0, -1.0);
            case 3 -> new Vector3(0.0, 0.0, 1.0);
            case 4 -> new Vector3(-1.0, 0.0, 0.0);
            case 5 -> new Vector3(1.0, 0.0, 0.0);
            default -> throw new IllegalStateException("Unexpected value: " + dir);
        };
        Vector3 itemPos = Vector3.fromBlockPosCenter((BlockPos)pos).add(dirVec.copy().multiply(0.6));
        Vector3 itemMotion = dirVec.copy().multiply(velocity);
        ItemEntity item = new ItemEntity(world, itemPos.x, itemPos.y, itemPos.z, stack);
        item.m_20334_(itemMotion.x, itemMotion.y, itemMotion.z);
        item.m_32010_(10);
        world.m_7967_((Entity)item);
    }
}

