/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.brake;

import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.config.CCConfigs;
import com.hlysine.create_connected.content.brake.BrakeBlock;
import com.hlysine.create_connected.datagen.advancements.AdvancementBehaviour;
import com.hlysine.create_connected.datagen.advancements.CCAdvancements;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class BrakeBlockEntity
extends SplitShaftBlockEntity {
    private static final int TICK_INTERVAL = 3;
    private static final float MIN_ADVANCEMENT_SPEED = 8.0f;
    private int tickTimer = 0;
    private boolean advancementAwarded = false;

    public BrakeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public float getRotationSpeedModifier(Direction face) {
        return 1.0f;
    }

    public float calculateStressApplied() {
        float impact;
        if (!((Boolean)this.m_58900_().m_61143_((Property)BrakeBlock.POWERED)).booleanValue()) {
            return super.calculateStressApplied();
        }
        this.lastStressApplied = impact = CCConfigs.server().brakeActiveStress.getF();
        return impact;
    }

    public void tick() {
        super.tick();
        if (this.tickTimer-- < 0) {
            boolean isBraking;
            this.tickTimer = 3;
            double unpoweredStress = BlockStressValues.getImpact((Block)((Block)CCBlocks.BRAKE.get()));
            double poweredStress = (Double)CCConfigs.server().brakeActiveStress.get();
            boolean bl = isBraking = (Boolean)this.m_58900_().m_61143_((Property)BrakeBlock.POWERED) == poweredStress >= unpoweredStress;
            if (unpoweredStress == poweredStress) {
                isBraking = unpoweredStress > 0.0;
            }
            float absSpeed = Mth.m_14154_((float)this.getSpeed());
            if (this.f_58857_.m_5776_()) {
                if (isBraking && absSpeed > 0.0f) {
                    Vec3 loc = Vec3.m_82539_((Vec3i)this.m_58899_());
                    this.f_58857_.m_6493_((ParticleOptions)ParticleTypes.f_123755_, false, loc.f_82479_, loc.f_82480_ + 0.5, loc.f_82481_, 0.0, 0.05, 0.0);
                }
            } else if (isBraking && absSpeed > 8.0f && !this.advancementAwarded) {
                this.advancementAwarded = true;
                AdvancementBehaviour.tryAward((BlockEntity)this, CCAdvancements.OVERPOWERED_BRAKE);
            } else if (!isBraking) {
                this.advancementAwarded = false;
            }
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        AdvancementBehaviour.registerAwardables((SmartBlockEntity)this, behaviours, CCAdvancements.OVERPOWERED_BRAKE);
    }
}

