/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.crankwheel;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCShapes;
import com.hlysine.create_connected.content.crankwheel.CrankWheelBlockEntity;
import com.simibubi.create.content.kinetics.crank.HandCrankBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrankWheelBlock
extends HandCrankBlock
implements ICogWheel {
    public static EnumProperty<Direction.Axis> AXIS = CogWheelBlock.AXIS;
    public final boolean largeCog;

    public CrankWheelBlock(BlockBehaviour.Properties properties, boolean largeCog) {
        super(properties);
        this.largeCog = largeCog;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AXIS});
        super.m_7926_(builder);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.largeCog ? CCShapes.LARGE_CRANK_WHEEL.get((Direction)state.m_61143_((Property)FACING)) : CCShapes.CRANK_WHEEL.get((Direction)state.m_61143_((Property)FACING));
    }

    public BlockEntityType<? extends CrankWheelBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.CRANK_WHEEL.get();
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        BlockState defaultBlockState = this.withWater(this.m_49966_(), context);
        if (preferred == null || context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return (BlockState)((BlockState)defaultBlockState.m_61124_((Property)FACING, (Comparable)context.m_43719_())).m_61124_(AXIS, (Comparable)context.m_43719_().m_122434_());
        }
        Direction facing = Direction.m_122387_((Direction.Axis)preferred.m_122434_(), (Direction.AxisDirection)context.m_7820_().m_122424_().m_122421_());
        return (BlockState)((BlockState)defaultBlockState.m_61124_((Property)FACING, (Comparable)facing)).m_61124_(AXIS, (Comparable)facing.m_122434_());
    }

    public Direction getPreferredFacing(BlockPlaceContext context) {
        Direction preferredSide = null;
        for (Direction side : Iterate.directions) {
            ICogWheel cog;
            Direction.Axis rotationAxis;
            BlockState blockState = context.m_43725_().m_8055_(context.m_8083_().m_121945_(side));
            Block block = blockState.m_60734_();
            if (!(block instanceof ICogWheel) || (rotationAxis = (cog = (ICogWheel)block).getRotationAxis(blockState)) == side.m_122434_()) continue;
            if (preferredSide != null && preferredSide.m_122434_() != rotationAxis) {
                preferredSide = null;
                break;
            }
            preferredSide = Direction.m_122387_((Direction.Axis)rotationAxis, (Direction.AxisDirection)side.m_122421_());
        }
        return preferredSide;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return CogWheelBlock.isValidCogwheelPosition((boolean)ICogWheel.isLargeCog((BlockState)state), (LevelReader)worldIn, (BlockPos)pos, (Direction.Axis)((Direction.Axis)state.m_61143_(AXIS)));
    }

    public BlockState rotate(BlockState state, LevelAccessor level, BlockPos pos, Rotation direction) {
        BlockState newState = super.rotate(state, level, pos, direction);
        return (BlockState)newState.m_61124_(AXIS, (Comparable)((Direction.Axis)newState.m_61143_(AXIS)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        BlockState newState = super.m_6943_(state, mirrorIn);
        return (BlockState)newState.m_61124_(AXIS, (Comparable)((Direction.Axis)newState.m_61143_(AXIS)));
    }

    public boolean isLargeCog() {
        return this.largeCog;
    }

    public boolean isSmallCog() {
        return !this.largeCog;
    }

    public static class Large
    extends CrankWheelBlock {
        public Large(BlockBehaviour.Properties properties) {
            super(properties, true);
        }
    }

    public static class Small
    extends CrankWheelBlock {
        public Small(BlockBehaviour.Properties properties) {
            super(properties, false);
        }
    }
}

