/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.config.CServer;
import com.hlysine.create_connected.content.fluidvessel.CreativeFluidVesselBlockEntity;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlock;
import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlockEntity;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlockEntity;
import com.simibubi.create.content.fluids.tank.BoilerData;
import com.simibubi.create.content.fluids.tank.BoilerHeaters;
import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.content.kinetics.BlockStressValues;
import com.simibubi.create.content.kinetics.steamEngine.SteamEngineBlock;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class BoilerData
extends com.simibubi.create.content.fluids.tank.BoilerData {
    static final int SAMPLE_RATE = 5;
    private static final int waterSupplyPerLevel = 10;
    private static final float passiveEngineEfficiency = 0.125f;
    int gatheredSupply;
    float[] supplyOverTime = new float[10];
    int ticksUntilNextSample;
    int currentIndex;
    int configLevelCap = 18;
    private int maxHeatForSize = 0;
    private int maxHeatForWater = 0;
    private int minValue = 0;
    private int maxValue = 0;

    public void tick(FluidTankBlockEntity controller) {
        if (!this.isActive()) {
            return;
        }
        this.configLevelCap = CServer.VesselMaxLevel.get();
        if (controller.m_58904_().f_46443_) {
            this.gauge.tickChaser();
            float current = this.gauge.getValue(1.0f);
            if (current > 1.0f && Create.RANDOM.nextFloat() < 0.5f) {
                this.gauge.setValueNoUpdate((double)(current + Math.min(-(current - 1.0f) * Create.RANDOM.nextFloat(), 0.0f)));
            }
            return;
        }
        if (this.needsHeatLevelUpdate && this.updateTemperature(controller)) {
            controller.notifyUpdate();
        }
        --this.ticksUntilNextSample;
        if (this.ticksUntilNextSample > 0) {
            return;
        }
        int capacity = controller.getTankInventory().getCapacity();
        if (capacity == 0) {
            return;
        }
        this.ticksUntilNextSample = 5;
        this.supplyOverTime[this.currentIndex] = (float)this.gatheredSupply / 5.0f;
        this.waterSupply = Math.max(this.waterSupply, this.supplyOverTime[this.currentIndex]);
        this.currentIndex = (this.currentIndex + 1) % this.supplyOverTime.length;
        this.gatheredSupply = 0;
        if (this.currentIndex == 0) {
            this.waterSupply = 0.0f;
            for (float i : this.supplyOverTime) {
                this.waterSupply = Math.max(i, this.waterSupply);
            }
        }
        if (controller instanceof CreativeFluidVesselBlockEntity) {
            this.waterSupply = 200.0f;
        }
        if (this.getActualHeat(controller.getTotalTankSize()) == 18) {
            controller.award(AllAdvancements.STEAM_ENGINE_MAXED);
        }
        controller.notifyUpdate();
    }

    public int getTheoreticalHeatLevel() {
        return this.activeHeat;
    }

    public int getMaxHeatLevelForBoilerSize(int boilerSize) {
        return Math.min(18, boilerSize / 4);
    }

    public int getMaxHeatLevelForWaterSupply() {
        return Math.min(18, Mth.m_14167_((float)this.waterSupply) / 10);
    }

    public boolean isPassive() {
        return this.passiveHeat && this.maxHeatForSize > 0 && this.maxHeatForWater > 0;
    }

    public boolean isPassive(int boilerSize) {
        this.calcMinMaxForSize(boilerSize);
        return this.isPassive();
    }

    public float getEngineEfficiency(int boilerSize) {
        if (this.isPassive(boilerSize)) {
            return 0.125f / (float)this.attachedEngines * CServer.VesselBoilerStressMultiplier.get().floatValue();
        }
        if (this.activeHeat == 0) {
            return 0.0f;
        }
        int actualHeat = this.getActualHeat(boilerSize);
        return (this.attachedEngines <= actualHeat ? 1.0f : (float)actualHeat / (float)this.attachedEngines) * CServer.VesselBoilerStressMultiplier.get().floatValue();
    }

    private int getActualHeat(int boilerSize) {
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize)), this.configLevelCap);
        return actualHeat;
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking, int boilerSize) {
        if (!this.isActive()) {
            return false;
        }
        MutableComponent indent = Components.literal((String)"    ");
        MutableComponent indent2 = Components.literal((String)"     ");
        this.calcMinMaxForSize(boilerSize);
        if (this.configLevelCap < 18) {
            tooltip.add((Component)indent.m_6879_().m_7220_((Component)Lang.translateDirect((String)"boiler.status", (Object[])new Object[]{this.getHeatLevelTextComponent().m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)(" / " + this.configLevelCap)).m_130940_(ChatFormatting.GRAY))})));
        } else {
            tooltip.add((Component)indent.m_6879_().m_7220_((Component)Lang.translateDirect((String)"boiler.status", (Object[])new Object[]{this.getHeatLevelTextComponent().m_130940_(ChatFormatting.GREEN)})));
        }
        tooltip.add((Component)indent2.m_6879_().m_7220_((Component)this.getSizeComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.m_6879_().m_7220_((Component)this.getWaterComponent(true, false, new ChatFormatting[0])));
        tooltip.add((Component)indent2.m_6879_().m_7220_((Component)this.getHeatComponent(true, false, new ChatFormatting[0])));
        if (this.attachedEngines == 0) {
            return true;
        }
        int boilerLevel = Math.min(Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize)), this.configLevelCap);
        double totalSU = (double)(this.getEngineEfficiency(boilerSize) * 16.0f * (float)Math.max(boilerLevel, this.attachedEngines)) * BlockStressValues.getCapacity((Block)((Block)AllBlocks.STEAM_ENGINE.get()));
        tooltip.add(Components.immutableEmpty());
        if (this.attachedEngines > 0 && this.maxHeatForSize > 0 && this.maxHeatForWater == 0 && (this.passiveHeat ? 1 : this.activeHeat) > 0) {
            Lang.translate((String)"boiler.water_input_rate", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
            Lang.number((double)this.waterSupply).style(ChatFormatting.BLUE).add(Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0])).add(Lang.text((String)" / ").style(ChatFormatting.GRAY)).add(Lang.translate((String)"boiler.per_tick", (Object[])new Object[]{Lang.number((double)10.0).add(Lang.translate((String)"generic.unit.millibuckets", (Object[])new Object[0]))}).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
            return true;
        }
        Lang.translate((String)"tooltip.capacityProvided", (Object[])new Object[0]).style(ChatFormatting.GRAY).forGoggles(tooltip);
        Lang.number((double)totalSU).translate("generic.unit.stress", new Object[0]).style(ChatFormatting.AQUA).space().add((this.attachedEngines == 1 ? Lang.translate((String)"boiler.via_one_engine", (Object[])new Object[0]) : Lang.translate((String)"boiler.via_engines", (Object[])new Object[]{this.attachedEngines})).style(ChatFormatting.DARK_GRAY)).forGoggles(tooltip, 1);
        return true;
    }

    public void calcMinMaxForSize(int boilerSize) {
        this.maxHeatForSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        this.maxHeatForWater = this.getMaxHeatLevelForWaterSupply();
        this.minValue = Math.min(this.configLevelCap, Math.min(this.passiveHeat ? 1 : this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize)));
        this.maxValue = Math.max(this.passiveHeat ? 1 : this.activeHeat, Math.max(this.maxHeatForWater, this.maxHeatForSize));
    }

    @NotNull
    public MutableComponent getHeatLevelTextComponent() {
        int boilerLevel = Math.min(Math.min(this.activeHeat, Math.min(this.maxHeatForWater, this.maxHeatForSize)), this.configLevelCap);
        return this.isPassive() ? Lang.translateDirect((String)"boiler.passive", (Object[])new Object[0]) : (boilerLevel == 0 ? Lang.translateDirect((String)"boiler.idle", (Object[])new Object[0]) : (boilerLevel == 18 ? Lang.translateDirect((String)"boiler.max_lvl", (Object[])new Object[0]) : Lang.translateDirect((String)"boiler.lvl", (Object[])new Object[]{String.valueOf(boilerLevel)})));
    }

    public MutableComponent getSizeComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("size", this.maxHeatForSize, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getWaterComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("water", this.maxHeatForWater, forGoggles, useBlocksAsBars, styles);
    }

    public MutableComponent getHeatComponent(boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        return this.componentHelper("heat", this.passiveHeat ? 1 : this.activeHeat, forGoggles, useBlocksAsBars, styles);
    }

    private MutableComponent componentHelper(String label, int level, boolean forGoggles, boolean useBlocksAsBars, ChatFormatting ... styles) {
        MutableComponent base;
        MutableComponent mutableComponent = base = useBlocksAsBars ? this.blockComponent(level) : this.barComponent(level);
        if (!forGoggles) {
            return base;
        }
        ChatFormatting style1 = styles.length >= 1 ? styles[0] : ChatFormatting.GRAY;
        ChatFormatting style2 = styles.length >= 2 ? styles[1] : ChatFormatting.DARK_GRAY;
        return Lang.translateDirect((String)("boiler." + label), (Object[])new Object[0]).m_130940_(style1).m_7220_((Component)Lang.translateDirect((String)("boiler." + label + "_dots"), (Object[])new Object[0]).m_130940_(style2)).m_7220_((Component)base);
    }

    private MutableComponent blockComponent(int level) {
        return Components.literal((String)("\u2588".repeat(this.minValue) + "\u2592".repeat(level - this.minValue) + "\u2591".repeat(this.maxValue - level)));
    }

    private MutableComponent barComponent(int level) {
        return Components.empty().m_7220_((Component)this.bars(Math.max(0, this.minValue - 1), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(this.minValue > 0 ? 1 : 0, ChatFormatting.GREEN)).m_7220_((Component)this.bars(Math.max(0, level - this.minValue), ChatFormatting.DARK_GREEN)).m_7220_((Component)this.bars(Math.max(0, this.maxValue - level), ChatFormatting.DARK_RED)).m_7220_((Component)this.bars(Math.max(0, Math.min(18 - this.maxValue, (this.maxValue / 5 + 1) * 5 - this.maxValue)), ChatFormatting.DARK_GRAY));
    }

    private MutableComponent bars(int level, ChatFormatting format) {
        return Components.literal((String)Strings.repeat((char)'|', (int)level)).m_130940_(format);
    }

    public boolean evaluate(FluidTankBlockEntity base) {
        if (!(base instanceof FluidVesselBlockEntity)) {
            return super.evaluate(base);
        }
        FluidVesselBlockEntity controller = (FluidVesselBlockEntity)base;
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        this.configLevelCap = CServer.VesselMaxLevel.get();
        int prevEngines = this.attachedEngines;
        int prevWhistles = this.attachedWhistles;
        this.attachedEngines = 0;
        this.attachedWhistles = 0;
        Direction.Axis axis = controller.getAxis();
        for (int yOffset = 0; yOffset < controller.getWidth(); ++yOffset) {
            for (int lengthOffset = 0; lengthOffset < controller.getHeight(); ++lengthOffset) {
                for (int widthOffset = 0; widthOffset < controller.getWidth(); ++widthOffset) {
                    BlockPos pos = controllerPos.m_7918_(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                    BlockState blockState = level.m_8055_(pos);
                    if (!FluidVesselBlock.isVessel(blockState)) continue;
                    for (Direction d : Iterate.directions) {
                        BlockPos attachedPos = pos.m_121945_(d);
                        BlockState attachedState = level.m_8055_(attachedPos);
                        if (AllBlocks.STEAM_ENGINE.has(attachedState) && SteamEngineBlock.getFacing((BlockState)attachedState) == d) {
                            ++this.attachedEngines;
                        }
                        if (!AllBlocks.STEAM_WHISTLE.has(attachedState) || WhistleBlock.getAttachedDirection((BlockState)attachedState).m_122424_() != d) continue;
                        ++this.attachedWhistles;
                    }
                }
            }
        }
        this.needsHeatLevelUpdate = true;
        return prevEngines != this.attachedEngines || prevWhistles != this.attachedWhistles;
    }

    public void checkPipeOrganAdvancement(FluidTankBlockEntity base) {
        if (!(base instanceof FluidVesselBlockEntity)) {
            super.checkPipeOrganAdvancement(base);
            return;
        }
        FluidVesselBlockEntity controller = (FluidVesselBlockEntity)base;
        if (!((AdvancementBehaviour)controller.getBehaviour(AdvancementBehaviour.TYPE)).isOwnerPresent()) {
            return;
        }
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        HashSet<Integer> whistlePitches = new HashSet<Integer>();
        Direction.Axis axis = controller.getAxis();
        for (int yOffset = 0; yOffset < controller.getWidth(); ++yOffset) {
            for (int lengthOffset = 0; lengthOffset < controller.getHeight(); ++lengthOffset) {
                for (int widthOffset = 0; widthOffset < controller.getWidth(); ++widthOffset) {
                    BlockPos pos = controllerPos.m_7918_(axis == Direction.Axis.X ? lengthOffset : widthOffset, yOffset, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                    BlockState blockState = level.m_8055_(pos);
                    if (!FluidVesselBlock.isVessel(blockState)) continue;
                    for (Direction d : Iterate.directions) {
                        BlockEntity blockEntity;
                        BlockPos attachedPos = pos.m_121945_(d);
                        BlockState attachedState = level.m_8055_(attachedPos);
                        if (!AllBlocks.STEAM_WHISTLE.has(attachedState) || WhistleBlock.getAttachedDirection((BlockState)attachedState).m_122424_() != d || !((blockEntity = level.m_7702_(attachedPos)) instanceof WhistleBlockEntity)) continue;
                        WhistleBlockEntity wbe = (WhistleBlockEntity)blockEntity;
                        whistlePitches.add(wbe.getPitchId());
                    }
                }
            }
        }
        if (whistlePitches.size() >= 12) {
            controller.award(AllAdvancements.PIPE_ORGAN);
        }
    }

    public boolean updateTemperature(FluidTankBlockEntity base) {
        if (!(base instanceof FluidVesselBlockEntity)) {
            return super.evaluate(base);
        }
        FluidVesselBlockEntity controller = (FluidVesselBlockEntity)base;
        BlockPos controllerPos = controller.m_58899_();
        Level level = controller.m_58904_();
        this.needsHeatLevelUpdate = false;
        boolean prevPassive = this.passiveHeat;
        int prevActive = this.activeHeat;
        this.passiveHeat = false;
        this.activeHeat = 0;
        Direction.Axis axis = controller.getAxis();
        for (int lengthOffset = 0; lengthOffset < controller.getHeight(); ++lengthOffset) {
            for (int widthOffset = 0; widthOffset < controller.getWidth(); ++widthOffset) {
                BlockState blockState;
                BlockPos pos = controllerPos.m_7918_(axis == Direction.Axis.X ? lengthOffset : widthOffset, -1, axis == Direction.Axis.Z ? lengthOffset : widthOffset);
                float heat = BoilerHeaters.getActiveHeat((Level)level, (BlockPos)pos, (BlockState)(blockState = level.m_8055_(pos)));
                if (heat == 0.0f) {
                    this.passiveHeat = true;
                    continue;
                }
                if (!(heat > 0.0f)) continue;
                this.activeHeat = (int)((float)this.activeHeat + heat);
            }
        }
        this.activeHeat = Math.max(0, Math.min(18, (int)Math.floor((float)this.activeHeat * CServer.VesselHeatMultiplier.get().floatValue())));
        this.passiveHeat &= this.activeHeat == 0;
        return prevActive != this.activeHeat || prevPassive != this.passiveHeat;
    }

    public boolean isActive() {
        return this.attachedEngines > 0 || this.attachedWhistles > 0;
    }

    public void clear() {
        this.waterSupply = 0.0f;
        this.activeHeat = 0;
        this.passiveHeat = false;
        this.attachedEngines = 0;
        Arrays.fill(this.supplyOverTime, 0.0f);
    }

    public CompoundTag write() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_("Supply", this.waterSupply);
        nbt.m_128405_("ActiveHeat", this.activeHeat);
        nbt.m_128379_("PassiveHeat", this.passiveHeat);
        nbt.m_128405_("Engines", this.attachedEngines);
        nbt.m_128405_("Whistles", this.attachedWhistles);
        nbt.m_128379_("Update", this.needsHeatLevelUpdate);
        return nbt;
    }

    public void read(CompoundTag nbt, int boilerSize) {
        this.waterSupply = nbt.m_128457_("Supply");
        this.activeHeat = nbt.m_128451_("ActiveHeat");
        this.passiveHeat = nbt.m_128471_("PassiveHeat");
        this.attachedEngines = nbt.m_128451_("Engines");
        this.attachedWhistles = nbt.m_128451_("Whistles");
        this.needsHeatLevelUpdate = nbt.m_128471_("Update");
        Arrays.fill(this.supplyOverTime, (float)((int)this.waterSupply));
        int forBoilerSize = this.getMaxHeatLevelForBoilerSize(boilerSize);
        int forWaterSupply = this.getMaxHeatLevelForWaterSupply();
        int actualHeat = Math.min(this.activeHeat, Math.min(forWaterSupply, forBoilerSize));
        float target = this.isPassive(boilerSize) ? 0.125f : (forBoilerSize == 0 ? 0.0f : (float)actualHeat / ((float)forBoilerSize * 1.0f));
        this.gauge.chase((double)target, 0.125, LerpedFloat.Chaser.EXP);
    }

    public BoilerFluidHandler createHandler() {
        return new BoilerFluidHandler();
    }

    public class BoilerFluidHandler
    extends BoilerData.BoilerFluidHandler {
        public BoilerFluidHandler() {
            super((com.simibubi.create.content.fluids.tank.BoilerData)BoilerData.this);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.isFluidValid(0, resource)) {
                return 0;
            }
            int amount = resource.getAmount();
            if (action.execute()) {
                BoilerData.this.gatheredSupply += amount;
            }
            return amount;
        }
    }
}

