/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.fluidvessel;

import com.hlysine.create_connected.content.fluidvessel.FluidVesselBlockEntity;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.fluid.FluidRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FluidVesselRenderer
extends SafeBlockEntityRenderer<FluidVesselBlockEntity> {
    public FluidVesselRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(FluidVesselBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (!be.hasWindow()) {
            if (be.boiler.isActive()) {
                this.renderAsBoiler(be, partialTicks, ms, buffer, light, overlay);
            }
            return;
        }
        LerpedFloat fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capSize = 0.25f;
        float tankHullSize = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.getWidth() - 2.0f * tankHullSize - minPuddleHeight;
        float level = fluidLevel.getValue(partialTicks);
        if (level < 1.0f / (512.0f * totalHeight)) {
            return;
        }
        float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
        FluidTank tank = (FluidTank)be.getTankInventory();
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        boolean top = fluidStack.getFluid().getFluidType().isLighterThanAir();
        Direction.Axis axis = be.getAxis();
        float xMin = axis == Direction.Axis.X ? capSize : tankHullSize;
        float xMax = axis == Direction.Axis.X ? xMin + (float)be.getHeight() - 2.0f * capSize : xMin + (float)be.getWidth() - 2.0f * tankHullSize;
        float yMin = totalHeight + tankHullSize + minPuddleHeight - clampedLevel;
        float yMax = yMin + clampedLevel;
        if (top) {
            yMin += totalHeight - clampedLevel;
            yMax += totalHeight - clampedLevel;
        }
        float zMin = axis == Direction.Axis.Z ? capSize : tankHullSize;
        float zMax = axis == Direction.Axis.Z ? zMin + (float)be.getHeight() - 2.0f * capSize : zMin + (float)be.getWidth() - 2.0f * tankHullSize;
        ms.m_85836_();
        ms.m_252880_(0.0f, clampedLevel - totalHeight, 0.0f);
        FluidRenderer.renderFluidBox((FluidStack)fluidStack, (float)xMin, (float)yMin, (float)zMin, (float)xMax, (float)yMax, (float)zMax, (MultiBufferSource)buffer, (PoseStack)ms, (int)light, (boolean)false);
        ms.m_85849_();
    }

    protected void renderAsBoiler(FluidVesselBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.m_58900_();
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        ms.m_85836_();
        TransformStack msr = TransformStack.cast((PoseStack)ms);
        Direction.Axis axis = be.getAxis();
        msr.translate(axis == Direction.Axis.X ? (double)((float)be.getHeight() / 2.0f) : (double)((float)be.getWidth() / 2.0f), 0.5, axis == Direction.Axis.Z ? (double)((float)be.getHeight() / 2.0f) : (double)((float)be.getWidth() / 2.0f));
        float dialPivot = 0.359375f;
        float progress = be.boiler.gauge.getValue(partialTicks);
        for (Direction d : Iterate.horizontalDirections) {
            if (d.m_122434_() != axis) continue;
            ms.m_85836_();
            ((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)AllPartialModels.BOILER_GAUGE, (BlockState)blockState).rotateY((double)d.m_122435_())).unCentre()).translate((double)((float)be.getWidth() / 2.0f - 0.375f), 0.0, 0.0).light(light).renderInto(ms, vb);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)AllPartialModels.BOILER_GAUGE_DIAL, (BlockState)blockState).rotateY((double)d.m_122435_())).unCentre()).translate((double)((float)be.getWidth() / 2.0f - 0.375f), 0.0, 0.0).translate(0.0, (double)dialPivot, (double)dialPivot).rotateX((double)(-90.0f * progress))).translate(0.0, (double)(-dialPivot), (double)(-dialPivot)).light(light).renderInto(ms, vb);
            ms.m_85849_();
        }
        ms.m_85849_();
    }

    public boolean shouldRenderOffScreen(FluidVesselBlockEntity be) {
        return be.isController();
    }
}

