/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.datagen.recipes;

import com.hlysine.create_connected.CreateConnected;
import com.hlysine.create_connected.datagen.recipes.CuttingRecipeGen;
import com.hlysine.create_connected.datagen.recipes.FillingRecipeGen;
import com.hlysine.create_connected.datagen.recipes.ItemApplicationRecipeGen;
import com.simibubi.create.content.processing.recipe.ProcessingRecipe;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeSerializer;
import com.simibubi.create.foundation.data.recipe.CreateRecipeProvider;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import com.simibubi.create.foundation.utility.RegisteredObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessingRecipeGen
extends CreateRecipeProvider {
    protected static final List<ProcessingRecipeGen> GENERATORS = new ArrayList<ProcessingRecipeGen>();
    protected static final int BUCKET = 1000;
    protected static final int BOTTLE = 250;

    public static void registerAll(DataGenerator gen, PackOutput output) {
        GENERATORS.add(new CuttingRecipeGen(output));
        GENERATORS.add(new ItemApplicationRecipeGen(output));
        GENERATORS.add(new FillingRecipeGen(output));
        gen.addProvider(true, new DataProvider(){

            @NotNull
            public String m_6055_() {
                return "Create: Connected's Processing Recipes";
            }

            @NotNull
            public CompletableFuture<?> m_213708_(@NotNull CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.m_213708_(dc)).toArray(CompletableFuture[]::new));
            }
        });
    }

    public ProcessingRecipeGen(PackOutput generator) {
        super(generator);
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(String namespace, Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = c -> {
            ItemLike itemLike = (ItemLike)singleIngredient.get();
            ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), new ResourceLocation(namespace, RegisteredObjects.getKeyOrThrow((Item)itemLike.m_5456_()).m_135815_())).withItemIngredients(new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike})}))).build(c);
        };
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(Supplier<ItemLike> singleIngredient, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create("create_connected", singleIngredient, transform);
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe createWithDeferredId(Supplier<ResourceLocation> name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        ProcessingRecipeSerializer serializer = this.getSerializer();
        CreateRecipeProvider.GeneratedRecipe generatedRecipe = c -> ((ProcessingRecipeBuilder)transform.apply(new ProcessingRecipeBuilder(serializer.getFactory(), (ResourceLocation)name.get()))).build(c);
        this.all.add(generatedRecipe);
        return generatedRecipe;
    }

    protected <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(ResourceLocation name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.createWithDeferredId(() -> name, transform);
    }

    <T extends ProcessingRecipe<?>> CreateRecipeProvider.GeneratedRecipe create(String name, UnaryOperator<ProcessingRecipeBuilder<T>> transform) {
        return this.create(CreateConnected.asResource(name), transform);
    }

    protected abstract IRecipeTypeInfo getRecipeType();

    protected <T extends ProcessingRecipe<?>> ProcessingRecipeSerializer<T> getSerializer() {
        return (ProcessingRecipeSerializer)this.getRecipeType().getSerializer();
    }

    protected Supplier<ResourceLocation> idWithSuffix(Supplier<ItemLike> item, String suffix) {
        return () -> {
            ResourceLocation registryName = RegisteredObjects.getKeyOrThrow((Item)((ItemLike)item.get()).m_5456_());
            return CreateConnected.asResource(registryName.m_135815_() + suffix);
        };
    }

    @NotNull
    public String m_6055_() {
        return "Create: Connected's Processing Recipes: " + this.getRecipeType().getId().m_135815_();
    }
}

