/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.entity;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.satisfy.bloomingnature.core.registry.EntityTypeRegistry;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class ModBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> WOOD_TYPE = SynchedEntityData.m_135353_(ModBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ModBoatEntity(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public ModBoatEntity(Level level, double x, double y, double z) {
        this(EntityTypeRegistry.MOD_BOAT.get(), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(WOOD_TYPE, (Object)0);
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("Type", 8)) {
            this.setWoodType(Type.byName(pCompound.m_128461_("Type")));
        }
    }

    protected void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("Type", this.getWoodType().getName());
    }

    public Type getWoodType() {
        return Type.byId((Integer)this.f_19804_.m_135370_(WOOD_TYPE));
    }

    public void setWoodType(Type type) {
        this.f_19804_.m_135381_(WOOD_TYPE, (Object)type.ordinal());
    }

    @NotNull
    public Item m_38369_() {
        return this.getWoodType().getItem().get();
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public static enum Type {
        ASPEN("aspen", (Supplier<Item>)ObjectRegistry.ASPEN_BOAT, (Supplier<Item>)ObjectRegistry.ASPEN_CHEST_BOAT),
        BAOBAB("baobab", (Supplier<Item>)ObjectRegistry.BAOBAB_BOAT, (Supplier<Item>)ObjectRegistry.BAOBAB_CHEST_BOAT),
        LARCH("larch", (Supplier<Item>)ObjectRegistry.LARCH_BOAT, (Supplier<Item>)ObjectRegistry.LARCH_CHEST_BOAT),
        EBONY("ebony", (Supplier<Item>)ObjectRegistry.EBONY_BOAT, (Supplier<Item>)ObjectRegistry.EBONY_CHEST_BOAT),
        CHESTNUT("chestnut", (Supplier<Item>)ObjectRegistry.CHESTNUT_BOAT, (Supplier<Item>)ObjectRegistry.CHESTNUT_CHEST_BOAT),
        SWAMP_OAK("swamp_oak", (Supplier<Item>)ObjectRegistry.SWAMP_OAK_BOAT, (Supplier<Item>)ObjectRegistry.SWAMP_OAK_CHEST_BOAT),
        SWAMP_CYPRESS("swamp_cypress", (Supplier<Item>)ObjectRegistry.SWAMP_CYPRESS_BOAT, (Supplier<Item>)ObjectRegistry.SWAMP_CYPRESS_CHEST_BOAT),
        FAN_PALM("fan_palm", (Supplier<Item>)ObjectRegistry.FAN_PALM_BOAT, (Supplier<Item>)ObjectRegistry.FAN_PALM_CHEST_BOAT),
        FIR("fir", (Supplier<Item>)ObjectRegistry.FIR_BOAT, (Supplier<Item>)ObjectRegistry.FIR_CHEST_BOAT),
        CACTUS("cactus", (Supplier<Item>)ObjectRegistry.CACTUS_BOAT, (Supplier<Item>)ObjectRegistry.CACTUS_CHEST_BOAT);

        private final String name;
        private final Supplier<Item> item;
        private final Supplier<Item> chestItem;

        private Type(String name, Supplier<Item> boatItem, Supplier<Item> chestBoatItem) {
            this.name = name;
            this.item = boatItem;
            this.chestItem = chestBoatItem;
        }

        public ResourceLocation getTexture(boolean hasChest) {
            if (hasChest) {
                return new ResourceLocation("bloomingnature", "textures/entity/chest_boat/" + this.name + ".png");
            }
            return new ResourceLocation("bloomingnature", "textures/entity/boat/" + this.name + ".png");
        }

        public String getModelLocation() {
            return "boat/" + this.name;
        }

        public String getChestModelLocation() {
            return "chest_boat/" + this.name;
        }

        public String getName() {
            return this.name;
        }

        public Supplier<Item> getItem() {
            return this.item;
        }

        public Supplier<Item> getChestItem() {
            return this.chestItem;
        }

        public static Type byId(int id) {
            Type[] values = Type.values();
            if (id < 0 || id >= values.length) {
                id = 0;
            }
            return values[id];
        }

        public static Type byName(String name) {
            Type[] values;
            for (Type value : values = Type.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return values[0];
        }
    }
}

