/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.registry;

import dev.architectury.registry.level.entity.EntityAttributeRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.bloomingnature.core.block.entity.CompletionistBannerEntity;
import net.satisfy.bloomingnature.core.block.entity.FlowerPotBigBlockEntity;
import net.satisfy.bloomingnature.core.block.entity.ModHangingSignBlockEntity;
import net.satisfy.bloomingnature.core.block.entity.ModSignBlockEntity;
import net.satisfy.bloomingnature.core.block.entity.StorageBlockEntity;
import net.satisfy.bloomingnature.core.entity.ModBoatEntity;
import net.satisfy.bloomingnature.core.entity.ModChestBoatEntity;
import net.satisfy.bloomingnature.core.entity.TermiteEntity;
import net.satisfy.bloomingnature.core.entity.WanderingGardenerEntity;
import net.satisfy.bloomingnature.core.registry.ObjectRegistry;
import net.satisfy.bloomingnature.core.registry.StorageTypeRegistry;
import net.satisfy.bloomingnature.core.util.BloomingNatureIdentifier;
import net.satisfy.bloomingnature.platform.PlatformHelper;

public class EntityTypeRegistry {
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"bloomingnature", (ResourceKey)Registries.f_256922_);
    private static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((String)"bloomingnature", (ResourceKey)Registries.f_256939_);
    public static final RegistrySupplier<EntityType<WanderingGardenerEntity>> WANDERING_GARDENER = EntityTypeRegistry.registerEntity("wandering_gardener", () -> EntityType.Builder.m_20704_(WanderingGardenerEntity::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.6f, 1.95f).m_20702_(10).m_20712_(new BloomingNatureIdentifier("wandering_gardener").toString()));
    public static final RegistrySupplier<EntityType<TermiteEntity>> TERMITE = EntityTypeRegistry.registerEntity("termite", () -> EntityType.Builder.m_20704_(TermiteEntity::new, (MobCategory)MobCategory.MONSTER).m_20712_(new BloomingNatureIdentifier("termite").toString()));
    public static final Supplier<EntityType<ModBoatEntity>> MOD_BOAT = PlatformHelper.registerBoatType("mod_boat", ModBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final Supplier<EntityType<ModChestBoatEntity>> MOD_CHEST_BOAT = PlatformHelper.registerBoatType("mod_chest_boat", ModChestBoatEntity::new, MobCategory.MISC, 1.375f, 0.5625f, 10);
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.m_155273_(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<FlowerPotBigBlockEntity>> FLOWER_POT_BIG_ENTITY = EntityTypeRegistry.registerBlockEntity("flower_pot_big", () -> BlockEntityType.Builder.m_155273_(FlowerPotBigBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> BLOOMINGNATURE_BANNER = EntityTypeRegistry.registerBlockEntity("bloomingnature_banner", () -> BlockEntityType.Builder.m_155273_(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BLOOMINGNATURE_BANNER.get(), (Block)ObjectRegistry.BLOOMINGNATURE_WALL_BANNER.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<ModSignBlockEntity>> MOD_SIGN = BLOCK_ENTITY_TYPES.register("mod_sign", () -> BlockEntityType.Builder.m_155273_(ModSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LARCH_SIGN.get(), (Block)ObjectRegistry.LARCH_WALL_SIGN.get(), (Block)ObjectRegistry.ASPEN_SIGN.get(), (Block)ObjectRegistry.ASPEN_WALL_SIGN.get(), (Block)ObjectRegistry.BAOBAB_SIGN.get(), (Block)ObjectRegistry.BAOBAB_WALL_SIGN.get(), (Block)ObjectRegistry.EBONY_SIGN.get(), (Block)ObjectRegistry.EBONY_WALL_SIGN.get(), (Block)ObjectRegistry.CHESTNUT_SIGN.get(), (Block)ObjectRegistry.CHESTNUT_WALL_SIGN.get(), (Block)ObjectRegistry.SWAMP_OAK_SIGN.get(), (Block)ObjectRegistry.SWAMP_OAK_WALL_SIGN.get(), (Block)ObjectRegistry.SWAMP_CYPRESS_SIGN.get(), (Block)ObjectRegistry.SWAMP_CYPRESS_WALL_SIGN.get(), (Block)ObjectRegistry.FAN_PALM_SIGN.get(), (Block)ObjectRegistry.FAN_PALM_WALL_SIGN.get(), (Block)ObjectRegistry.FIR_SIGN.get(), (Block)ObjectRegistry.FIR_WALL_SIGN.get(), (Block)ObjectRegistry.CACTUS_SIGN.get(), (Block)ObjectRegistry.CACTUS_WALL_SIGN.get()}).m_58966_(null));
    public static final RegistrySupplier<BlockEntityType<ModHangingSignBlockEntity>> MOD_HANGING_SIGN = BLOCK_ENTITY_TYPES.register("mod_hanging_sign", () -> BlockEntityType.Builder.m_155273_(ModHangingSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.LARCH_HANGING_SIGN.get(), (Block)ObjectRegistry.LARCH_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.ASPEN_HANGING_SIGN.get(), (Block)ObjectRegistry.ASPEN_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.BAOBAB_HANGING_SIGN.get(), (Block)ObjectRegistry.BAOBAB_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.EBONY_HANGING_SIGN.get(), (Block)ObjectRegistry.EBONY_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.CHESTNUT_HANGING_SIGN.get(), (Block)ObjectRegistry.CHESTNUT_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.SWAMP_OAK_HANGING_SIGN.get(), (Block)ObjectRegistry.SWAMP_OAK_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.SWAMP_CYPRESS_HANGING_SIGN.get(), (Block)ObjectRegistry.SWAMP_CYPRESS_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.FAN_PALM_HANGING_SIGN.get(), (Block)ObjectRegistry.FAN_PALM_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.FIR_HANGING_SIGN.get(), (Block)ObjectRegistry.FIR_WALL_HANGING_SIGN.get(), (Block)ObjectRegistry.CACTUS_HANGING_SIGN.get(), (Block)ObjectRegistry.CACTUS_WALL_HANGING_SIGN.get()}).m_58966_(null));

    public static <T extends EntityType<?>> RegistrySupplier<T> registerEntity(String path, Supplier<T> type) {
        return ENTITY_TYPES.register((ResourceLocation)new BloomingNatureIdentifier(path), type);
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String path, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register((ResourceLocation)new BloomingNatureIdentifier(path), type);
    }

    static void registerAttributes() {
        EntityAttributeRegistry.register(WANDERING_GARDENER, Mob::m_21552_);
        EntityAttributeRegistry.register(TERMITE, TermiteEntity::createMobAttributes);
    }

    public static void init() {
        ENTITY_TYPES.register();
        BLOCK_ENTITY_TYPES.register();
        EntityTypeRegistry.registerAttributes();
    }
}

