/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bloomingnature.core.world.placers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.satisfy.bloomingnature.core.registry.PlacerTypesRegistry;

public class FanPalmFoliagePlacer
extends FoliagePlacer {
    public static final Codec<FanPalmFoliagePlacer> CODEC = RecordCodecBuilder.create(instance -> FanPalmFoliagePlacer.m_68573_((RecordCodecBuilder.Instance)instance).and((App)Codec.intRange((int)0, (int)16).fieldOf("leaf_length").forGetter(placer -> placer.leafLength)).apply((Applicative)instance, FanPalmFoliagePlacer::new));
    private final int leafLength;

    public FanPalmFoliagePlacer(IntProvider range, IntProvider rangeOffset, int leafLength) {
        super(range, rangeOffset);
        this.leafLength = leafLength;
    }

    protected FoliagePlacerType<?> m_5897_() {
        return (FoliagePlacerType)PlacerTypesRegistry.FAN_PALM_FOLIAGE_PLACER.get();
    }

    protected void m_213633_(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int trunkHeight, FoliagePlacer.FoliageAttachment foliageAttachment, int foliageHeight, int radius, int offset) {
        int i;
        BlockPos blockPos = foliageAttachment.m_161451_();
        int attempts = randomSource.m_188503_(this.leafLength) + 3;
        this.placeLeaf(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockPos);
        BlockPos.MutableBlockPos mutableBlockPos = blockPos.m_122032_();
        for (i = 0; i > -1; --i) {
            int j = 1 + i;
            this.m_225628_(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, blockPos, j, i, false);
        }
        for (i = 0; i < 10; ++i) {
            mutableBlockPos.m_122154_((Vec3i)blockPos, randomSource.m_188503_(radius) - randomSource.m_188503_(radius), randomSource.m_188503_(radius) - radius + 2, randomSource.m_188503_(radius) - randomSource.m_188503_(radius));
            this.placeLeaf(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, (BlockPos)mutableBlockPos);
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos.MutableBlockPos horizontalPos = new BlockPos.MutableBlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            int leavesGravity = 0;
            int maxLimit = attempts / 3;
            for (int i2 = 0; i2 < attempts; ++i2) {
                horizontalPos.m_122173_(direction);
                if (leavesGravity >= maxLimit) {
                    leavesGravity = 0;
                    this.placeLeaf(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, (BlockPos)horizontalPos);
                    horizontalPos.m_122173_(Direction.DOWN);
                } else {
                    ++leavesGravity;
                }
                this.placeLeaf(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, (BlockPos)horizontalPos);
            }
        }
    }

    public int m_214116_(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return 0;
    }

    protected void placeLeaf(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, BlockPos pos) {
        if (levelSimulatedReader.m_7433_(pos, state -> state.m_60795_() || state.m_60713_(treeConfiguration.f_161213_.m_213972_(randomSource, pos).m_60734_()))) {
            foliageSetter.m_271838_(pos, treeConfiguration.f_161213_.m_213972_(randomSource, pos));
        }
    }

    protected boolean m_214203_(RandomSource randomSource, int dx, int dy, int dz, int radius, boolean large) {
        return false;
    }
}

