/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib;

import appeng.menu.locator.MenuLocators;
import de.mari_023.ae2wtlib.AE2WTLibCreativeTab;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.AE2wtlibConfig;
import de.mari_023.ae2wtlib.AE2wtlibEvents;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.curio.CurioLocator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod(value="ae2wtlib")
@Mod.EventBusSubscriber
public class AE2wtlibForge {
    public static final HashMap<String, Item> ITEMS = new HashMap();
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"ae2wtlib");

    public AE2wtlibForge() {
        AE2wtlibConfig.init();
        if (Platform.trinketsPresent()) {
            MenuLocators.register(CurioLocator.class, CurioLocator::writeToPacket, CurioLocator::readFromPacket);
        }
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        RECIPES.register(modEventBus);
        modEventBus.addListener(event -> {
            if (event.getRegistryKey().equals((Object)ForgeRegistries.MENU_TYPES.getRegistryKey())) {
                AE2wtlib.registerMenus();
            } else if (event.getRegistryKey().equals((Object)ForgeRegistries.ITEMS.getRegistryKey())) {
                AE2wtlib.createItems();
                for (Map.Entry<String, Item> entry : ITEMS.entrySet()) {
                    ForgeRegistries.ITEMS.register(entry.getKey(), (Object)entry.getValue());
                }
                AE2wtlib.onAe2Initialized();
            } else if (event.getRegistryKey().equals((Object)Registries.f_279569_)) {
                AE2WTLibCreativeTab.init((Registry<CreativeModeTab>)Objects.requireNonNull(event.getVanillaRegistry()));
            }
        });
        modEventBus.addListener(event -> AE2wtlib.addToCreativeTab());
    }

    @SubscribeEvent
    public static void handle(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        AE2wtlibEvents.restock(player, event.getItem(), event.getResultStack().m_41613_(), arg_0 -> ((LivingEntityUseItemEvent.Finish)event).setResultStack(arg_0));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handle(PlayerInteractEvent.RightClickBlock event) {
        ServerPlayer player;
        block3: {
            block2: {
                Player player2 = event.getEntity();
                if (!(player2 instanceof ServerPlayer)) break block2;
                player = (ServerPlayer)player2;
                if (!event.isCanceled()) break block3;
            }
            return;
        }
        ItemStack item = event.getItemStack();
        AE2wtlibEvents.restock(player, item, item.m_41613_(), stack -> player.m_21008_(event.getHand(), stack));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handle(EntityItemPickupEvent event) {
        if (event.isCanceled()) {
            return;
        }
        event.setCanceled(AE2wtlibEvents.insertStackInME(event.getItem().m_32055_(), event.getEntity()));
    }
}

