/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.crafting;

import appeng.block.AEBaseEntityBlock;
import appeng.block.crafting.PushDirection;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.menu.locator.MenuLocators;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class PatternProviderBlock
extends AEBaseEntityBlock<PatternProviderBlockEntity> {
    public static final EnumProperty<PushDirection> PUSH_DIRECTION = EnumProperty.m_61587_((String)"push_direction", PushDirection.class);

    public PatternProviderBlock() {
        super(PatternProviderBlock.metalProps());
        this.m_49959_((BlockState)this.m_49966_().m_61124_(PUSH_DIRECTION, (Comparable)((Object)PushDirection.ALL)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PUSH_DIRECTION});
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        PatternProviderBlockEntity be = (PatternProviderBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            be.getLogic().updateRedstoneState();
        }
    }

    @Override
    public InteractionResult onActivated(Level level, BlockPos pos, Player p, InteractionHand hand, @Nullable ItemStack heldItem, BlockHitResult hit) {
        if (InteractionUtil.isInAlternateUseMode(p)) {
            return InteractionResult.PASS;
        }
        if (heldItem != null && InteractionUtil.canWrenchRotate(heldItem)) {
            this.setSide(level, pos, hit.m_82434_());
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        PatternProviderBlockEntity be = (PatternProviderBlockEntity)this.getBlockEntity((BlockGetter)level, pos);
        if (be != null) {
            if (!level.m_5776_()) {
                be.openMenu(p, MenuLocators.forBlockEntity(be));
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    public void setSide(Level level, BlockPos pos, Direction facing) {
        BlockState currentState = level.m_8055_(pos);
        Direction pushSide = ((PushDirection)((Object)currentState.m_61143_(PUSH_DIRECTION))).getDirection();
        PushDirection newPushDirection = pushSide == facing.m_122424_() ? PushDirection.fromDirection(facing) : (pushSide == facing ? PushDirection.ALL : (pushSide == null ? PushDirection.fromDirection(facing.m_122424_()) : PushDirection.fromDirection(Platform.rotateAround(pushSide, facing))));
        level.m_46597_(pos, (BlockState)currentState.m_61124_(PUSH_DIRECTION, (Comparable)((Object)newPushDirection)));
    }
}

