/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.loot;

import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.IAE2DataProvider;
import appeng.datagen.providers.tags.ConventionTags;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.jetbrains.annotations.NotNull;

public class BlockDropProvider
extends BlockLootSubProvider
implements IAE2DataProvider {
    private final Map<Block, Function<Block, LootTable.Builder>> overrides = this.createOverrides();
    private final Path outputFolder;

    @NotNull
    private ImmutableMap<Block, Function<Block, LootTable.Builder>> createOverrides() {
        return ImmutableMap.builder().put((Object)AEBlocks.MATRIX_FRAME.block(), $ -> LootTable.m_79147_()).put((Object)AEBlocks.MYSTERIOUS_CUBE.block(), BlockDropProvider::mysteriousCube).put((Object)AEBlocks.FLAWLESS_BUDDING_QUARTZ.block(), this.flawlessBuddingQuartz()).put((Object)AEBlocks.FLAWED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.CHIPPED_BUDDING_QUARTZ)).put((Object)AEBlocks.CHIPPED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.DAMAGED_BUDDING_QUARTZ)).put((Object)AEBlocks.DAMAGED_BUDDING_QUARTZ.block(), this.buddingQuartz(AEBlocks.QUARTZ_BLOCK)).put((Object)AEBlocks.SMALL_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.MEDIUM_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.LARGE_QUARTZ_BUD.block(), this::quartzBud).put((Object)AEBlocks.QUARTZ_CLUSTER.block(), BlockDropProvider::quartzCluster).build();
    }

    public BlockDropProvider(PackOutput output) {
        super(Set.of(), FeatureFlagSet.m_246902_());
        this.outputFolder = output.m_245114_();
    }

    public void m_245660_() {
    }

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
        super.m_245126_(biConsumer);
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        for (Map.Entry entry : BuiltInRegistries.f_256975_.m_6579_()) {
            if (!((ResourceKey)entry.getKey()).m_135782_().m_135827_().equals("ae2")) continue;
            LootTable.Builder builder = this.overrides.getOrDefault(entry.getValue(), this::defaultBuilder).apply((Block)entry.getValue());
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.toJson(builder), (Path)this.getPath(this.outputFolder, ((ResourceKey)entry.getKey()).m_135782_())));
        }
        futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)this.toJson(LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_(AEBlocks.SKY_STONE_BLOCK)))), (Path)this.getPath(this.outputFolder, AppEng.makeId("chests/meteorite"))));
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    private LootTable.Builder defaultBuilder(Block block) {
        LootPoolSingletonContainer.Builder entry = LootItem.m_79579_((ItemLike)block);
        LootPool.Builder pool = LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)entry).m_79080_(ExplosionCondition.m_81661_());
        return LootTable.m_79147_().m_79161_(pool);
    }

    private Function<Block, LootTable.Builder> flawlessBuddingQuartz() {
        return b -> this.m_247033_((ItemLike)AEBlocks.FLAWED_BUDDING_QUARTZ.block());
    }

    private Function<Block, LootTable.Builder> buddingQuartz(BlockDefinition<?> degradedVersion) {
        return b -> this.m_245514_((Block)b, degradedVersion);
    }

    private LootTable.Builder quartzBud(Block bud) {
        return this.m_245514_(bud, AEItems.CERTUS_QUARTZ_DUST);
    }

    private static LootTable.Builder quartzCluster(Block cluster) {
        return BlockDropProvider.m_247502_((Block)cluster, (LootPoolEntryContainer.Builder)LootItem.m_79579_(AEItems.CERTUS_QUARTZ_CRYSTAL).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)4.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_)).m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()));
    }

    private static LootTable.Builder mysteriousCube(Block block) {
        return BlockDropProvider.m_247502_((Block)block, (LootPoolEntryContainer.Builder)TagEntry.m_205084_(ConventionTags.INSCRIBER_PRESSES).m_79080_(ExplosionCondition.m_81661_()));
    }

    private Path getPath(Path root, ResourceLocation id) {
        return root.resolve("data/" + id.m_135827_() + "/loot_tables/blocks/" + id.m_135815_() + ".json");
    }

    public JsonElement toJson(LootTable.Builder builder) {
        return LootDataType.f_278413_.m_278857_().toJsonTree((Object)this.finishBuilding(builder));
    }

    public LootTable finishBuilding(LootTable.Builder builder) {
        return builder.m_79165_(LootContextParamSets.f_81421_).m_79167_();
    }

    public String m_6055_() {
        return "Applied Energistics 2 Block Drops";
    }
}

