/*
 * Decompiled with CFR 0.152.
 */
package appeng.libs.micromark.html;

import appeng.libs.micromark.CharUtil;
import appeng.libs.micromark.html.HtmlEncode;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public final class SanitizeUri {
    private static final Predicate<String> ASCII_PATTERN = Pattern.compile("[!#$&-;=?-Z_a-z~]").asMatchPredicate();

    private SanitizeUri() {
    }

    public static String sanitizeUri(String url, @Nullable Pattern protocol) {
        String value = HtmlEncode.encode(SanitizeUri.normalizeUri(Objects.requireNonNullElse(url, "")));
        if (protocol == null) {
            return value;
        }
        int colon = value.indexOf(58);
        int questionMark = value.indexOf(63);
        int numberSign = value.indexOf(35);
        int slash = value.indexOf(47);
        if (colon < 0 || slash > -1 && colon > slash || questionMark > -1 && colon > questionMark || numberSign > -1 && colon > numberSign || protocol.matcher(value.substring(0, colon)).matches()) {
            return value;
        }
        return "";
    }

    public static String normalizeUri(String value) {
        StringBuilder result = new StringBuilder();
        int index = -1;
        int start = 0;
        int skip = 0;
        while (++index < value.length()) {
            char code = value.charAt(index);
            String replace = null;
            if (code == '%' && index + 2 < value.length() && CharUtil.asciiAlphanumeric(value.charAt(index + 1)) && CharUtil.asciiAlphanumeric(value.charAt(index + 2))) {
                skip = 2;
            } else if (code < '\u0080') {
                if (!ASCII_PATTERN.test(String.valueOf(code))) {
                    replace = String.valueOf(code);
                }
            } else if (code > '\ud7ff' && code < '\ue000') {
                char next;
                char c = next = index + 1 < value.length() ? value.charAt(index + 1) : (char)'\u0000';
                if (code < '\udc00' && next > '\udbff' && next < '\ue000') {
                    replace = String.valueOf(new char[]{code, next});
                    skip = 1;
                } else {
                    replace = String.valueOf('\ufffd');
                }
            } else {
                replace = String.valueOf(code);
            }
            if (replace != null) {
                result.append(value, start, index);
                result.append(URLEncoder.encode(replace, StandardCharsets.UTF_8).replace("+", "%20"));
                start = index + skip + 1;
                replace = null;
            }
            if (skip <= 0) continue;
            index += skip;
            skip = 0;
        }
        result.append(value, start, value.length());
        return result.toString();
    }
}

