/*
 * Decompiled with CFR 0.152.
 */
package appeng.recipes.entropy;

import appeng.core.AppEng;
import appeng.init.InitRecipeTypes;
import appeng.recipes.entropy.EntropyMode;
import appeng.recipes.entropy.EntropyRecipeSerializer;
import appeng.recipes.entropy.StateApplier;
import appeng.recipes.entropy.StateMatcher;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class EntropyRecipe
implements Recipe<Container> {
    public static final ResourceLocation TYPE_ID = AppEng.makeId("entropy");
    public static final RecipeType<EntropyRecipe> TYPE = InitRecipeTypes.register(TYPE_ID.toString());
    private final ResourceLocation id;
    private final EntropyMode mode;
    @Nullable
    private final Block inputBlock;
    private final List<StateMatcher> inputBlockMatchers;
    @Nullable
    private final Fluid inputFluid;
    private final List<StateMatcher> inputFluidMatchers;
    @Nullable
    private final Block outputBlock;
    private final List<StateApplier<?>> outputBlockStateAppliers;
    private final boolean outputBlockKeep;
    @Nullable
    private final Fluid outputFluid;
    private final List<StateApplier<?>> outputFluidStateAppliers;
    private final boolean outputFluidKeep;
    private final List<ItemStack> drops;

    public EntropyRecipe(ResourceLocation id, EntropyMode mode, Block inputBlock, List<StateMatcher> inputBlockMatchers, Fluid inputFluid, List<StateMatcher> inputFluidMatchers, Block outputBlock, List<StateApplier<?>> outputBlockStateAppliers, boolean outputBlockKeep, Fluid outputFluid, List<StateApplier<?>> outputFluidStateAppliers, boolean outputFluidKeep, List<ItemStack> drops) {
        Preconditions.checkArgument((inputBlock != null || inputFluid != null ? 1 : 0) != 0, (Object)"One of inputBlock or inputFluid must not be null");
        this.id = Objects.requireNonNull(id, "id must not be null");
        this.mode = Objects.requireNonNull(mode, "mode must not be null");
        this.inputBlock = inputBlock;
        this.inputBlockMatchers = Objects.requireNonNull(inputBlockMatchers, "inputBlockMatchers must be not null");
        this.inputFluid = inputFluid;
        this.inputFluidMatchers = Objects.requireNonNull(inputFluidMatchers, "inputFluidMatchers must be not null");
        this.outputBlock = outputBlock;
        this.outputBlockStateAppliers = Objects.requireNonNull(outputBlockStateAppliers, "outputBlockStateAppliers must be not null");
        this.outputBlockKeep = outputBlockKeep;
        this.outputFluid = outputFluid;
        this.outputFluidStateAppliers = Objects.requireNonNull(outputFluidStateAppliers, "outputFluidStateAppliers must be not null");
        this.outputFluidKeep = outputFluidKeep;
        this.drops = Objects.requireNonNull(drops, "drops must not be null");
    }

    public boolean m_5818_(Container inv, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return EntropyRecipeSerializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return TYPE;
    }

    public NonNullList<Ingredient> m_7527_() {
        return NonNullList.m_122779_();
    }

    public EntropyMode getMode() {
        return this.mode;
    }

    @Nullable
    public Block getInputBlock() {
        return this.inputBlock;
    }

    @Nullable
    public Fluid getInputFluid() {
        return this.inputFluid;
    }

    @Nullable
    public Block getOutputBlock() {
        return this.outputBlock;
    }

    public boolean getOutputBlockKeep() {
        return this.outputBlockKeep;
    }

    @Nullable
    public BlockState getOutputBlockState(BlockState originalBlockState) {
        if (this.getOutputBlock() == null) {
            return null;
        }
        BlockState state = this.getOutputBlock().m_49966_();
        if (this.outputBlockKeep) {
            for (Property property : originalBlockState.m_61147_()) {
                state = EntropyRecipe.copyProperty(originalBlockState, state, property);
            }
        }
        for (StateApplier stateApplier : this.outputBlockStateAppliers) {
            state = stateApplier.apply(state);
        }
        return state;
    }

    @Nullable
    public Fluid getOutputFluid() {
        return this.outputFluid;
    }

    public boolean getOutputFluidKeep() {
        return this.outputFluidKeep;
    }

    @Nullable
    public FluidState getOutputFluidState(FluidState originalFluidState) {
        if (this.getOutputFluid() == null) {
            return null;
        }
        FluidState state = this.getOutputFluid().m_76145_();
        if (this.outputFluidKeep) {
            for (Property property : originalFluidState.m_61147_()) {
                state = EntropyRecipe.copyProperty(originalFluidState, state, property);
            }
        }
        for (StateApplier stateApplier : this.outputFluidStateAppliers) {
            state = stateApplier.apply(state);
        }
        return state;
    }

    public List<ItemStack> getDrops() {
        return this.drops;
    }

    public boolean matches(EntropyMode mode, BlockState blockState, FluidState fluidState) {
        if (this.getMode() != mode) {
            return false;
        }
        if (blockState.m_60734_() != this.getInputBlock() && this.getInputBlock() != null) {
            return false;
        }
        if (fluidState.m_76152_() != this.getInputFluid() && this.getInputFluid() != null) {
            return false;
        }
        boolean isValid = true;
        if (fluidState.m_76152_() == this.getInputFluid()) {
            isValid = this.inputFluidMatchers.stream().allMatch(m -> m.matches((StateHolder<?, ?>)fluidState));
        }
        return isValid;
    }

    List<StateMatcher> getInputBlockMatchers() {
        return this.inputBlockMatchers;
    }

    List<StateMatcher> getInputFluidMatchers() {
        return this.inputFluidMatchers;
    }

    List<StateApplier<?>> getOutputBlockStateAppliers() {
        return this.outputBlockStateAppliers;
    }

    List<StateApplier<?>> getOutputFluidStateAppliers() {
        return this.outputFluidStateAppliers;
    }

    private static <T extends Comparable<T>, SH extends StateHolder<?, SH>> SH copyProperty(SH from, SH to, Property<T> property) {
        if (to.m_61138_(property)) {
            return (SH)((StateHolder)to.m_61124_(property, from.m_61143_(property)));
        }
        return to;
    }
}

