/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import java.time.Instant;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public final class TransitionInfo {
    public static final String TAG_WORLD_ID = "world_id";
    public static final String TAG_MIN = "min";
    public static final String TAG_MAX = "max";
    public static final String TAG_TIMESTAMP = "timestamp";
    private final ResourceLocation worldId;
    private final BlockPos min;
    private final BlockPos max;
    private final Instant timestamp;

    public TransitionInfo(ResourceLocation worldId, BlockPos min, BlockPos max, Instant timestamp) {
        this.worldId = worldId;
        this.min = min.m_7949_();
        this.max = max.m_7949_();
        this.timestamp = timestamp;
    }

    public ResourceLocation getWorldId() {
        return this.worldId;
    }

    public BlockPos getMin() {
        return this.min;
    }

    public BlockPos getMax() {
        return this.max;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public CompoundTag toTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(TAG_WORLD_ID, this.worldId.toString());
        tag.m_128365_(TAG_MIN, (Tag)NbtUtils.m_129224_((BlockPos)this.min));
        tag.m_128365_(TAG_MAX, (Tag)NbtUtils.m_129224_((BlockPos)this.max));
        tag.m_128356_(TAG_TIMESTAMP, this.timestamp.toEpochMilli());
        return tag;
    }

    public static TransitionInfo fromTag(CompoundTag tag) {
        ResourceLocation worldId = new ResourceLocation(tag.m_128461_(TAG_WORLD_ID));
        BlockPos min = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TAG_MIN));
        BlockPos max = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(TAG_MAX));
        Instant timestamp = Instant.ofEpochMilli(tag.m_128454_(TAG_TIMESTAMP));
        return new TransitionInfo(worldId, min, max, timestamp);
    }
}

